<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('home_videos', function (Blueprint $table) {
             $table->id();
            $table->string('title')->nullable(); // Introducing
            $table->string('subtitle')->nullable(); // Custom Curtains
            $table->string('video'); // mp4 or video url
            $table->string('button_text')->nullable(); // Shop Now
            $table->foreignId('product_id')->constrained()->cascadeOnDelete();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('home_videos');
    }
};
