<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('business_profiles', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');

            $table->enum('business_type', ['retail_firm', 'construction_firm']);

            $table->string('legal_shop_name');
            $table->text('legal_shop_address')->nullable();
            $table->string('shop_mobile_number', 20)->nullable();
            $table->string('gst_number')->nullable();

            $table->enum('approval_status', ['pending', 'approved', 'rejected'])
                ->default('pending');

            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('business_profiles');
    }
};
