<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();

            // Relations
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('billing_address_id')->constrained('user_addresses');

            // Order identity
            $table->string('order_number')->unique();

            // Amounts
            $table->decimal('sub_total', 10, 2);
            $table->decimal('delivery_fee', 10, 2)->default(0);
            $table->decimal('discount', 10, 2)->default(0);
            $table->decimal('total_amount', 10, 2);

            // Status
            $table->enum('status', [
               'placed','processing','shipped','delivered','cancelled','Returned'
            ])->default('placed');
            $table->date('expected_delivery_date')->nullable();
            $table->timestamp('delivered_at')->nullable();
            // Payment
            $table->enum('payment_method', ['razorpay', 'cod'])->default('razorpay');
            $table->enum('payment_status', ['pending', 'success', 'failed'])->default('pending');

            // Razorpay
            $table->string('razorpay_order_id')->nullable();
            $table->string('razorpay_payment_id')->nullable();
            $table->string('razorpay_signature')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
