<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::table('products', function (Blueprint $table) {
    // $table->string('master_catalogue_name')->after('subcategory_id');
    // $table->string('master_catalogue_code')->after('master_catalogue_name');
 $table->enum('visibility', ['B2C', 'B2B', 'Franchise', 'All'])->default('All');

            // Tax
            $table->decimal('gst_percent', 5, 2)->nullable(); // e.g., 18.00
            $table->boolean('gst_inclusive')->default(true); // including/excluding GST

            // Variant & Attribute Logic
            $table->boolean('is_parent')->default(true);
            $table->json('related_products')->nullable(); // array of product_ids
            $table->json('cross_sell_products')->nullable();
            $table->json('upsell_products')->nullable();
            $table->boolean('is_featured')->default(false);

            // SEO
            $table->string('seo_title')->nullable();
            $table->text('seo_description')->nullable();
            $table->text('search_keywords')->nullable();

            // Care Instructions
            $table->text('care_instructions')->nullable();

            // Optional analytics
            $table->boolean('fast_moving')->nullable(); // Fast / Slow moving
            $table->boolean('slow_moving')->nullable();
            $table->decimal('average_rating', 3, 2)->nullable(); // Customer rating out of 5
            $table->integer('review_count')->nullable();
        });

        Schema::table('product_variants', function (Blueprint $table) {
            // Optional performance analytics
            $table->boolean('fast_moving')->nullable();
            $table->boolean('slow_moving')->nullable();
    // $table->unique('master_catalogue_code');
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            //
        });
    }
};
