<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       Schema::create('products', function (Blueprint $table) {
    $table->id();

    $table->foreignId('category_id')->constrained('categories');
    $table->foreignId('subcategory_id')->constrained('sub_categories');
    $table->string('name'); // Textura Linen Blend
    $table->text('description')->nullable();

    // Material & design
    $table->string('material')->nullable(); 
    $table->string('features')->nullable(); // Blackout, Fire Retardant
    $table->string('maintenance')->nullable();

    // Warranty & certification
    $table->string('warranty_certification')->nullable();
    $table->string('measurement')->nullable();


    $table->boolean('is_active')->default(true);
    $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
