<?php

namespace App\Services;

use Illuminate\Support\Facades\Auth;

class PriceService
{
    public static function rolePrice($offerPrice)
    {
        if (!$offerPrice) {
            return 0;
        }

        $user = Auth::user();

        if (!$user || !$user->roles->first()) {
            return $offerPrice;
        }

        $percentage = $user->roles->first()->price_percentage ?? 100;

        return round(($offerPrice * $percentage) / 100, 2);
    }
}
