<?php

namespace App\Services;

use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging;
use Kreait\Firebase\Auth;

class FirebaseService
{
    protected Auth $auth;
    protected Messaging $messaging;

    public function __construct()
    {
        $factory = (new Factory)
            ->withServiceAccount(storage_path('app/firebase/firebase-credendials.json'));

        $this->auth = $factory->createAuth();
        $this->messaging = $factory->createMessaging();
    }

    public function verifyIdToken(string $idToken)
    {
        return $this->auth->verifyIdToken($idToken);
    }

    public function sendPush($token, $title, $body, $data = [])
    {
        $message = [
            'token' => $token,
            'notification' => [
                'title' => $title,
                'body'  => $body,
            ],
            'data' => $data
        ];

        return $this->messaging->send($message);
    }
}
