<?php

namespace App\Providers;

use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use App\Events\SystemEvent;
use App\Listeners\LogActivityAndNotify;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event to listener mappings for the application.
     *
     * @var array<class-string, array<int, class-string>>
     */
    protected $listen = [
        // Default Laravel event
        // Registered::class => [
        //     SendEmailVerificationNotification::class,
        // ],

        // 🔔 Centralized System Event
        SystemEvent::class => [
            LogActivityAndNotify::class,
        ],
    ];

    /**
     * Register any events for your application.
     */
    public function boot(): void
    {
        //
    }

    /**
     * Determine if events and listeners should be discovered automatically.
     */
    public function shouldDiscoverEvents(): bool
    {
        return false;
    }
}
