<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;

class SystemNotification extends Notification
{
    use Queueable;

    public function __construct(
        public string $title,
        public string $message,
        public string $eventType,
        public ?int $subjectId = null,
        public ?string $subjectType = null
    ) {}

    /**
     * IMPORTANT: database MUST be returned
     */
    public function via($notifiable): array
    {
        return ['database']; // 👈 REQUIRED
    }

    /**
     * This saves data into notifications table
     */
    public function toDatabase($notifiable): array
    {
        return [
            'title'        => $this->title,
            'message'      => $this->message,
            'event_type'   => $this->eventType,
            'subject_id'   => $this->subjectId,
            'subject_type' => $this->subjectType,
        ];
    }
}
