<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Room extends Model
{
   protected $fillable = [
        'name',
        'image',
    ];
       protected $appends = ['image_full'];

        // This creates image_full field
    public function getImageFullAttribute()
    {
        if (!$this->image) {
            return null;
        }

        // If image already has http or https avoid duplicating
        if (str_starts_with($this->image, 'http')) {
            return $this->image;
        }

        return url($this->image);
    }

    // OPTIONAL — replace "image" in response with full URL
    protected $hidden = ['image', 'pivot'];

    protected $casts = [
        'image_full' => 'string'
    ];

}
