<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuotationItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'quotation_id',
        'project_item_id',
        'category',
        'product_id',
        'variant_id',
        'is_custom',
        'quantity',
        'unit',
        'price',
        'total',
        'notes',
        'area_id',
    ];

    protected $casts = [
    'measurement' => 'array',
    'details' => 'array',
];
    public function quotation()
    {
        return $this->belongsTo(Quotation::class);
    }

    public function details()
    {
        return $this->hasOne(QuotationItemDetail::class,'quotation_item_id');
    }
    public function product()
{
    return $this->belongsTo(Product::class);
}

public function variant()
{
    return $this->belongsTo(ProductVariant::class, 'variant_id');
}

public function projectItem()
{
    return $this->belongsTo(ProjectItem::class);
}

public function area()
{
    return $this->belongsTo(QuotationArea::class, 'area_id');
}
}