<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Quotation extends Model
{
    use HasFactory;

    protected $fillable = [
        'project_id',
        'quotation_number',
         'project_name',
        'customer_id',
        'customer_name',
        'customer_phone',
        'address',
        'location_lat',
        'location_lng',
        'project_type',
        'dealer_id',
        'architect_id',
        'status',
        'quotation_pdf',
        'expected_completion_date',
        'employee_name',
        'employee_contact',
        'subtotal',
        'tax',
        'grand_total',
        'status',
        'created_by',
    ];

    public function items()
    {
        return $this->hasMany(QuotationItem::class);
    }

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

      public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
    public function areas()
{
    return $this->hasMany(QuotationArea::class);
}
}