<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProjectItemCurtain extends Model
{
    protected $fillable = [
        'project_item_id','type','motorized','motor_control',
        'model','catalogue','serial_no',
        
    // ✅ Custom Fields
    'brand',
    'model_price',
    'fabric_width',
    'price_per_meter',
    'unit',
    ];

    public function item()
    {
        return $this->belongsTo(ProjectItem::class);
    }
}

