<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProjectArea extends Model
{
    protected $fillable = [
        'project_id',
        'room_id',
        'area_name',
        'sort_order'
    ];

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function items()
    {
        return $this->hasMany(ProjectItem::class, 'area_id');
    }
    public function room()
    {
        return $this->belongsTo(Room::class);
    }
}
