<?php

namespace App\Listeners;

use App\Events\SystemEvent;
use App\Models\ActivityLog;
use Illuminate\Support\Facades\Auth;
use App\Services\NotificationService;

class LogActivityAndNotify
{
    public function handle(SystemEvent $event): void
    {
        ActivityLog::create([
            'causer_id'   => Auth::id() ?? 1, // fallback admin
            'event_type'  => $event->eventType,
            'description' => $event->message,
            'subject_type' => $event->subject ? get_class($event->subject) : null,
            'subject_id'  => $event->subject->id ?? null,
            'changes'     => $event->changes,
        ]);

        // Activity log already works ✔

        //  if (in_array('dashboard', $event->channels)) {
        NotificationService::send(
            userId: $event->recipientId ?? 1,
            eventType: $event->eventType,
            title: $this->resolveTitle($event->eventType),
            message: $event->message,
            channels: $event->channels,
            subject: $event->subject
        );

        // }
    }

    private function resolveTitle(string $eventType): string
    {
        return match ($eventType) {
            'product_created' => 'New Product Added',
            'product_updated' => 'Product Updated',
            'role_created'    => 'New Role Created',
            'role_updated'    => 'Role Updated',
            default           => 'System Alert',
        };
    }
}
