<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class TrackUserActivity
{
    public function handle(Request $request, Closure $next)
    {
        if (auth()->check()) {

            $userId = auth()->id();

            // Cache is FAST (Redis/File)
            Cache::put(
                "user-is-online-{$userId}",
                true,
                now()->addMinutes(5)
            );

            // Optional DB update (throttled)
            if (!Cache::has("user-last-activity-saved-{$userId}")) {
                auth()->user()->update([
                    'last_activity_at' => now(),
                ]);

                Cache::put(
                    "user-last-activity-saved-{$userId}",
                    true,
                    now()->addMinutes(1)
                );
            }
        }

        return $next($request);
    }
}
