<?php 
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Spatie\Permission\Models\Permission;

class CheckPermission
{
    // public function handle(Request $request, Closure $next)
    // {
    //     $user = $request->user();

    //     if (!$user) {
    //         return redirect()->route('login');
    //     }

    //     $routeName = Route::currentRouteName();

    //     $excludedRoutes = [
    //         'home',
    //         'logout',
    //         'password.change',
    //         'notifications.list',
    //         'notifications.read',
    //         'notifications.delete',
    //         'notifications.delete-all',
    //         'notifications.mark-all-read',
    //         'notifications.toggle-read',
    //     ];

    //     if (in_array($routeName, $excludedRoutes)) {
    //         return $next($request);
    //     }

    //     if (!$routeName) {
    //         return redirect()->route('dashboard')
    //                          ->with('permission_error', 'You do not have permission to access that page.');
    //     }

    //     $permissionExists = Permission::where('name', $routeName)->exists();

    //     if ($permissionExists && !$user->can($routeName)) {
    //         // Redirect to dashboard with flash message
    //         return redirect()->route('dashboard')
    //                          ->with('permission_error', 'You do not have permission to access that page.');
    //     }

    //     return $next($request);
    // }

public function handle(Request $request, Closure $next)
{
    $user = $request->user();

    if (!$user) {
        return redirect()->route('login');
    }

    $routeName = Route::currentRouteName();

    $excludedRoutes = [
        'home','logout','password.change',
        'notifications.list','notifications.read',
        'notifications.delete','notifications.delete-all',
        'notifications.mark-all-read','notifications.toggle-read',
    ];

    if (in_array($routeName, $excludedRoutes)) {
        return $next($request);
    }

    // ✅ If route has no name → allow access
    if (!$routeName) {
        return $next($request);
    }

    // ✅ Check permission only if exists in DB
    $permissionExists = Permission::where('name', $routeName)->exists();

    if ($permissionExists && !$user->can($routeName)) {

        if ($request->ajax() || $request->wantsJson()) {
            return response()->json([
                'status' => false,
                'message' => 'You do not have permission to perform this action'
            ], 403);
        }

        return redirect()->route('dashboard')
            ->with('permission_error', 'You do not have permission to access that page.');
    }

    // ✅ If permission not in table → allow access
    return $next($request);
}


}
