<?php

namespace App\Http\Controllers;

use App\Models\BusinessProfile;
use Illuminate\Http\Request;
use App\Models\Room;
use App\Models\Tags;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\File;
use App\Models\WebSetting;
use App\Models\ContactSetting;
use App\Models\HomeSection;
use App\Models\HomeVideos;
use App\Models\Product;
use App\Models\Category;
use App\Models\Order;
use App\Models\User;
use App\Models\Project;

class SettingsController extends Controller
{


    public function dashboard()
    {
        return view('dashboard', [
            'totalOrders'   => Order::count(),
            'totalProducts' => Product::count(),
            'totalUsers'    => User::count(),
            'totalProjects' => Project::count(),
 'totalPendingRoleRequest' => BusinessProfile::where('approval_status','pending')->count(),

            'totalRevenue'  => Order::where('payment_status', 'success')->sum('total_amount'),

            'recentOrders'  => Order::with(['user', 'items.product'])
                ->latest()
                ->take(10)
                ->get(),
        ]);
    }

    public function addRoom(Request $request)
    {
        try {
            $request->validate([
                'name'       => 'required|string|max:255',
                'photo'      => 'nullable|image|mimes:jpg,jpeg,png,webp,avif|max:4096',
            ]);

            $imagePath = null;

            if ($request->hasFile('photo')) {
                $image = $request->photo;
                $imageName = time() . '-' . rand(100, 999) . '.' . $image->extension();
                $uploadPath = public_path('assets/upload/room/');

                if (!File::exists($uploadPath)) {
                    File::makeDirectory($uploadPath, 0755, true);
                }

                $image->move($uploadPath, $imageName);
                $imagePath = 'assets/upload/room/' . $imageName;
            }
            $res = Room::insert([
                'name' => $request->input('name'),
                'image' => $imagePath,
            ]);

            return response()->json(['success' => 'Room added successfully.']);
        } catch (\Illuminate\Validation\ValidationException $e) {

            return response()->json([
                'status' => false,
                'errors' => $e->errors(),
                'message' => 'Validation failed'
            ], 422);
        } catch (\Exception $e) {

            return response()->json([
                'status'  => false,
                'message' => $e->getMessage()
            ], 500);
        }
    }

    public function getRoom()
    {
        $users = Room::orderBy('id', 'DESC')->get();

        return DataTables::of($users)
            ->addIndexColumn()
            ->addColumn('name', function ($data) {
                return   $data->name;
            })
            ->addColumn('image', function ($data) {
                return '<img src="' . asset($data->image) . '" class="avatar-md">';
            })
            ->addColumn('action', function ($row) {
                return '<a href="" class="btn btn-sm btn-purple editroom" data-id="' . $row->id . '">Edit</a>
                <a href="" class="btn btn-sm btn-danger deleteroom" data-id="' . $row->id . '">Delete</a>';
            })
            ->escapeColumns([])
            ->make(true);
    }


    // Delete Room (AJAX)
    public function destroy($id)
    {
        $Room = Room::findOrFail($id);
        $Room->delete();
        return response()->json(['success' => 'Room deleted successfully.']);
    }

    public function update(Request $request, $id)
    {
        try {
            $request->validate([
                'name' => 'required|string|max:100',
                'photo'      => 'nullable|image|mimes:jpg,jpeg,png,webp,avif|max:4096',

            ]);
            // Image upload
            if ($request->hasFile('photo')) {
                $image = $request->file('photo');
                $imageName = time() . '-' . rand(100, 999) . '.' . $image->extension();
                $uploadPath = public_path('assets/upload/category/');

                if (!File::exists($uploadPath)) {
                    File::makeDirectory($uploadPath, 0755, true);
                }

                $image->move($uploadPath, $imageName);
                Room::where('id', $id)->update([
                    'image' =>  'assets/upload/category/' . $imageName,
                ]);
            }

            //$Room = Room::findOrFail($id);
            Room::where('id', $id)->update([
                'name' => $request->name,
            ]);

            return response()->json(['success' => 'Room updated successfully.']);
        } catch (\Illuminate\Validation\ValidationException $e) {

            return response()->json([
                'status' => false,
                'errors' => $e->errors(),
                'message' => 'Validation failed'
            ], 422);
        } catch (\Exception $e) {

            return response()->json([
                'status'  => false,
                'message' => $e->getMessage()
            ], 500);
        }
    }


    //**tags *************/

    public function addtag(Request $request)
    {
        $res = Tags::insert([
            'name' => $request->input('name')
        ]);


        if ($res == 1)
            return redirect()->back()->with('success', 'tag added successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function gettag()
    {
        $users = Tags::orderBy('id', 'DESC')->get();

        return DataTables::of($users)
            ->addIndexColumn()
            ->addColumn('name', function ($data) {
                return   $data->name;
            })

            ->addColumn('action', function ($row) {
                return '<a href="" class="btn btn-sm btn-purple edittag" data-id="' . $row->id . '">Edit</a>
                <a href="" class="btn btn-sm btn-danger deletetag" data-id="' . $row->id . '">Delete</a>';
            })
            ->escapeColumns([])
            ->make(true);
    }


    // Delete tag (AJAX)
    public function destroytag($id)
    {
        $tag = Tags::findOrFail($id);
        $tag->delete();
        return response()->json(['success' => 'tag deleted successfully.']);
    }

    public function updatetag(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:100',
        ]);

        //$tag = Tags::findOrFail($id);
        Tags::where('id', $id)->update([
            'name' => $request->name,
        ]);

        return response()->json(['success' => 'tag updated successfully.']);
    }


    public function index()
    {
        return view('admin.settings.index', [
            'webSettings'     => WebSetting::first(),
            'contactSettings' => ContactSetting::first(),
            'sections'        => HomeSection::with('category')->first(), // single
            'videos'          => HomeVideos::with('product')->get(),
            'categories'      => Category::all(),
            'products'        => Product::all(),
        ]);
    }

    public function saveWebSettings(Request $request)
    {
        $data = $request->validate([
            'razropay_key_id' => 'nullable',
            'razropay_secret_key' => 'nullable',
            'privacy_policy' => 'nullable',
            'terms_and_conditions' => 'nullable'
        ]);

        WebSetting::updateOrCreate(['id' => 1], $data);

        return response()->json(['success' => 'Web settings saved']);
    }
    public function saveContactSettings(Request $request)
    {
        $data = $request->validate([
            'customer_service' => 'nullable',
            'whatsapp' => 'nullable',
            'website' => 'nullable',
            'facebook' => 'nullable',
            'twitter' => 'nullable',
            'instagram' => 'nullable'
        ]);

        ContactSetting::updateOrCreate(['id' => 1], $data);

        return response()->json(['success' => 'Contact settings saved']);
    }
    public function addHomeSection(Request $request)
    {
        try {

            $data = $request->validate([
                'title' => 'required|string',
                'subtitle' => 'nullable|string',
                'category_id' => 'required|exists:categories,id'
            ]);

            // Update first record OR create new
            HomeSection::updateOrCreate(
                ['id' => $request->home_id],   // first row condition
                $data
            );

            return response()->json([
                'status' => true,
                'success' => 'Section saved successfully'
            ]);
        } catch (\Illuminate\Validation\ValidationException $e) {

            return response()->json([
                'status' => false,
                'message' => 'Validation error',
                'errors' => $e->errors()
            ], 422);
        } catch (\Exception $e) {

            return response()->json([
                'status' => false,
                'message' => $e->getMessage()
            ], 500);
        }
    }




    public function addHomeVideo(Request $request)
    {
        $data = $request->validate([
            'title'       => 'nullable|string',
            'subtitle'    => 'nullable|string',
            'button_text' => 'nullable|string',
            'product_id'  => 'required|exists:products,id',
            'video'       => 'nullable|file|mimes:mp4,mov,avi,webm|max:51200'
        ]);

        /* ---------- Upload Video ---------- */
        if ($request->hasFile('video')) {

            $video = $request->file('video');

            $videoName = time() . '-' . rand(100, 999) . '.' . $video->extension();

            $uploadPath = public_path('assets/upload/video/');

            if (!File::exists($uploadPath)) {
                File::makeDirectory($uploadPath, 0755, true);
            }

            $video->move($uploadPath, $videoName);

            $data['video'] = 'assets/upload/video/' . $videoName;
        }

        /* ---------- Save / Update ---------- */
        HomeVideos::updateOrCreate(
            ['id' => $request->video_id],
            $data
        );

        return response()->json([
            'status'  => true,
            'success' => 'Video saved successfully'
        ]);
    }
}
