<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Project;
use Barryvdh\DomPDF\Facade\Pdf;

class PdfController extends Controller
{
    public function measurement($id)
    {
         $project = Project::with([
        'areas.items.measurement',
        'areas.items.curtain',
        'areas.items.mattress',
        'areas.items.sofa',
        'areas.items.wallpaper',
        'areas.items.accessories'
    ])->findOrFail($id);

     $pdf = PDF::loadView('pdf.measurement', compact('project'));
    // $pdf = Pdf::loadView('pdf.measurement', compact('project'))
    //     ->setPaper('A4', 'portrait')
    //     ->setOptions([
    //         'isRemoteEnabled' => true,
    //         'isHtml5ParserEnabled' => true,
    //     ]);

 return view('pdf.measurement', compact('project'));
       
        return $pdf->download('measurement_'.$project->project_number.'.pdf');
    }

     public function invoice($id)
    {
        $project =  Project::with([
          'areas.items.measurement',
            'areas.items.product',
            'areas.items.variant'
        ])->findOrFail($id);

        $pdf = PDF::loadView('pdf.invoice', compact('project'));
        return $pdf->download('invoice.pdf');
    }
}
