<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Department;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class DepartmentController extends Controller
{
    /** Page */
    public function index()
    {
        return view('admin.users.departments');
    }

    /** Add */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:departments,name'
        ]);

        Department::create([
            'name' => $request->name
        ]);

        return back()->with('success', 'Department added successfully');
    }

    /** Listing */
    public function list()
    {
        $data = Department::latest()->get();

        return DataTables::of($data)
            ->addIndexColumn()

            ->addColumn('status', function ($row) {
                $checked = $row->is_active ? 'checked' : '';
                return '
                <div class="form-check form-switch">
                    <input class="form-check-input toggleStatus"
                        type="checkbox"
                        data-id="'.$row->id.'"
                        '.$checked.'>
                </div>';
            })

            ->addColumn('action', function ($row) {
                return '
                <button class="btn btn-sm btn-primary editDepartment" data-id="'.$row->id.'">Edit</button>
                <button class="btn btn-sm btn-danger deleteDepartment ms-1" data-id="'.$row->id.'">Delete</button>';
            })

            ->rawColumns(['status', 'action'])
            ->make(true);
    }

    /** Update */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|unique:departments,name,' . $id
        ]);

        Department::where('id', $id)->update([
            'name' => $request->name
        ]);

        return response()->json(['success' => 'Department updated']);
    }

    /** Status Toggle */
    public function changeStatus($id)
    {
        $department = Department::findOrFail($id);
        $department->is_active = !$department->is_active;
        $department->save();

        return response()->json([
            'success' => 'Status updated',
            'status' => $department->is_active
        ]);
    }

    /** Delete */
    public function destroy($id)
    {
        Department::findOrFail($id)->delete();

        return response()->json(['success' => 'Department deleted']);
    }
}
