<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\CourierService;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\File;
class CourierServicController extends Controller
{
      public function addcourierservice(Request $request)
    {
        try {
            $request->validate([
                'name'       => 'required|string|max:255',
                 'website'       => 'required|string',
                'photo'      => 'nullable|image|mimes:jpg,jpeg,png,webp,avif|max:4096',
            ]);

            $imagePath = null;

            if ($request->hasFile('photo')) {
                $image = $request->photo;
                $imageName = time() . '-' . rand(100, 999) . '.' . $image->extension();
                $uploadPath = public_path('assets/upload/courierservice/');

                if (!File::exists($uploadPath)) {
                    File::makeDirectory($uploadPath, 0755, true);
                }

                $image->move($uploadPath, $imageName);
                $imagePath = 'assets/upload/courierservice/' . $imageName;
            }
            $res = CourierService::insert([
                'name' => $request->input('name'),
                  'website' => $request->input('website'),
                'logo' => $imagePath,
            ]);

            return response()->json(['success' => 'courierservice added successfully.']);
        } catch (\Illuminate\Validation\ValidationException $e) {

            return response()->json([
                'status' => false,
                'errors' => $e->errors(),
                'message' => 'Validation failed'
            ], 422);
        } catch (\Exception $e) {

            return response()->json([
                'status'  => false,
                'message' => $e->getMessage()
            ], 500);
        }
    }

    public function getcourierservice()
    {
        $users = CourierService::orderBy('id', 'DESC')->get();

        return DataTables::of($users)
            ->addIndexColumn()
            ->addColumn('name', function ($data) {
                return   $data->name;
            })
->addColumn('website', function ($data) {
                return   $data->website;
            })
            ->addColumn('image', function ($data) {
                return '<img src="' . asset($data->logo) . '" class="avatar-md">';
            })
            ->addColumn('action', function ($row) {
                return '<a href="" class="btn btn-sm btn-purple editcourierservice" data-id="' . $row->id . '">Edit</a>
                <a href="" class="btn btn-sm btn-danger deletecourierservice" data-id="' . $row->id . '">Delete</a>';
            })
            ->escapeColumns([])
            ->make(true);
    }


    // Delete courierservice (AJAX)
    public function destroy($id)
    {
        $courierservice = CourierService::findOrFail($id);
        $courierservice->delete();
        return response()->json(['success' => 'courierservice deleted successfully.']);
    }

    public function update(Request $request, $id)
    {
        try {
            $request->validate([
                'name' => 'required|string|max:100',
                'website'       => 'required|string',
                'photo'      => 'nullable|image|mimes:jpg,jpeg,png,webp,avif|max:4096',

            ]);
            // Image upload
            if ($request->hasFile('photo')) {
                $image = $request->file('photo');
                $imageName = time() . '-' . rand(100, 999) . '.' . $image->extension();
                $uploadPath = public_path('assets/upload/category/');

                if (!File::exists($uploadPath)) {
                    File::makeDirectory($uploadPath, 0755, true);
                }

                $image->move($uploadPath, $imageName);
                CourierService::where('id', $id)->update([
                    'logo' =>  'assets/upload/category/' . $imageName,
                ]);
            }

            //$courierservice = CourierService::findOrFail($id);
            CourierService::where('id', $id)->update([
                'name' => $request->name,
                  'website' => $request->input('website'),
            ]);

            return response()->json(['success' => 'courierservice updated successfully.']);
        } catch (\Illuminate\Validation\ValidationException $e) {

            return response()->json([
                'status' => false,
                'errors' => $e->errors(),
                'message' => 'Validation failed'
            ], 422);
        } catch (\Exception $e) {

            return response()->json([
                'status'  => false,
                'message' => $e->getMessage()
            ], 500);
        }
    }
}
