<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use PDF;
use App\Models\Project;
use App\Models\Quotation;
use App\Models\Invoice;

class PdfController extends Controller
{

    public function measurement($id)
    {
        $project = Project::with([
            'areas.items.measurement',
            'areas.items.curtain',
            'areas.items.mattress',
            'areas.items.sofa',
            'areas.items.wallpaper',
            'areas.items.accessories',
            'areas.items.product',
            'areas.items.variant'
        ])->findOrFail($id);

        $pdf = PDF::loadView('pdf.measurement', compact('project'));
        return $pdf->download('measurement.pdf');
    }

    public function quotation($id)
    {
        $project = Project::with([
            'areas.items.measurement',
            'areas.items.product',
            'areas.items.variant'
        ])->findOrFail($id);

        $pdf = Pdf::loadView('pdf.quotation', compact('project'))
            ->setPaper('A4');

        return $pdf->download('quotation_' . $project->project_number . '.pdf');
    }

    public function invoice($id)
    {
        $project =  Project::with([
            'areas.items.measurement',
            'areas.items.product',
            'areas.items.variant'
        ])->findOrFail($id);

        $pdf = PDF::loadView('pdf.invoice', compact('project'));
        return $pdf->download('invoice.pdf');
    }
}
