<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\FAQ;
use Illuminate\Http\Request;
use App\Models\ContactSetting;
use App\Models\AccountDeletionRequest;
use Illuminate\Support\Facades\Auth;
use App\Models\WebSetting;

class FaqController extends Controller
{
    public function index(Request $request)
    {
        $query = Faq::where('status', 1);

        if ($request->type) {
            $query->where('type', $request->type);
        }

        $faqs = $query->orderBy('sort_order')
            ->latest()
            ->get();

        return response()->json([
            'success' => true,
            'data' => $faqs
        ]);
    }

    public function contactsetting()
    {
        $contact = ContactSetting::select(
            'customer_service',
            'whatsapp',
            'website',
            'facebook',
            'twitter',
            'instagram'
        )->first();

        return response()->json([
            'success' => true,
            'data' => $contact
        ]);
    }

     public function requestDeleteAccount(Request $request)
    {
        $user = Auth::user();

        // prevent duplicate request
        $existing = AccountDeletionRequest::where('user_id',$user->id)
                    ->where('status','pending')
                    ->first();

        if($existing){
            return response()->json([
                'success'=>false,
                'message'=>'Delete request already submitted'
            ]);
        }

        AccountDeletionRequest::create([
            'user_id'      => $user->id,
            'reason'       => $request->reason,
            'status'       => 'pending',
            'requested_at' => now()
        ]);

        return response()->json([
            'success'=>true,
            'message'=>'Account deletion request submitted'
        ]);
    }

     public function privacyPolicy()
    {
        $data = WebSetting::select('privacy_policy')->first();

        return response()->json([
            'success' => true,
            'data' => $data->privacy_policy ?? ''
        ]);
    }

    public function termsConditions()
    {
        $data = WebSetting::select('terms_and_conditions')->first();

        return response()->json([
            'success' => true,
            'data' => $data->terms_and_conditions ?? ''
        ]);
    }
}
