<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{

    protected $fillable = [
        // Relations
        'user_id',
        'billing_address_id',
        'shipping_address_id',
        // Order identity
        'order_number',

        // Amounts
        'sub_total',
        'delivery_fee',
        'discount',
        'total_amount',

        // Status
        'status',

        // Payment
        'payment_method',
        'payment_status',

        // Razorpay
        'razorpay_order_id',
        'razorpay_payment_id',
        'razorpay_signature',
        'coupon_id',
        'coupon_code'
    ];

    // app/Models/Order.php

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'expected_delivery_date' => 'datetime',
        'delivered_at' => 'datetime',
    ];

    public function items()
    {
        return $this->hasMany(OrderItem::class);
    }

    // In App\Models\Order.php

    public function billingAddress()
    {
        return $this->belongsTo(UserAddress::class, 'billing_address_id');
    }

    public function shippingAddress()
    {
        return $this->belongsTo(UserAddress::class, 'shipping_address_id');
    }


    public function statusHistory()
    {
        return $this->hasMany(OrderStatusHistory::class)
            ->orderBy('created_at');
    }
}
