<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    protected $fillable = [
        'project_number',
        'project_name',
        'customer_id',
        'customer_name',
        'customer_phone',
        'address',
        'location_lat',
        'location_lng',
        'project_type',
        'dealer_id',
        'architect_id',
        'status',
        'expected_completion_date',
        'employee_name',
        'employee_contact',
        'created_by'
    ];

    public function areas()
    {
        return $this->hasMany(ProjectArea::class);
    }

    public function items()
    {
        return $this->hasMany(ProjectItem::class);
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }


    public function client()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }



    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function dealer()
    {
        return $this->belongsTo(User::class, 'dealer_id');
    }

    public function architect()
    {
        return $this->belongsTo(User::class, 'architect_id');
    }


    // App\Models\Project.php



    public function getSubtotalAttribute()
    {
        $subtotal = 0;

        foreach ($this->areas as $area) {
            foreach ($area->items as $item) {
                // Use offer_price from variant, multiplied by quantity
                $rate = $item->variant ? $item->variant->offer_price : 0;
                $subtotal += $rate * $item->quantity;
            }
        }

        return $subtotal;
    }

    public function getTaxAttribute()
    {
        // example GST 18%
        return $this->subtotal * 0.18;
    }

    public function getGrandTotalAttribute()
    {
        return $this->subtotal + $this->tax;
    }
}
