<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Coupon extends Model
{
   protected $fillable = [

        // Basic coupon
        'code',
        'type',                 // percentage | fixed
        'value',

        // Relations
        'category_id',
        'product_id',

        // Discount rules
        'min_purchase',
        'max_discount_amount',  // cap (eg: 20% up to ₹1000)

        // Usage rules
        'max_uses',
        'used_count',
        'per_user_limit',

        // Validity
        'start_date',
        'end_date',
        'is_active',

        // Role & restrictions
        'allowed_roles',        // JSON array
        'first_time_user_only',

        // Stack & auto apply
        'is_stackable',
        'auto_apply',

        // Meta
        'description',
        'last_used_at',
    ];

    /**
     * Casts for correct data handling
     */
    protected $casts = [
        'allowed_roles' => 'array',
        'is_active' => 'boolean',
        'first_time_user_only' => 'boolean',
        'is_stackable' => 'boolean',
        'auto_apply' => 'boolean',
        'start_date' => 'date',
        'end_date' => 'date',
        'last_used_at' => 'datetime',
    ];


    public function category() {
        return $this->belongsTo(Category::class);
    }

    public function product() {
        return $this->belongsTo(Product::class);
    }
//     public function orders()
// {
//     return $this->hasMany(Order::class);
// }

}
