<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Cart extends Model
{
    use HasFactory;

     protected $fillable = [
        'user_id',
        'coupon_id',
        'discount',
        'total'
    ];


    /* Relationships */

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function items()
    {
        return $this->hasMany(CartItem::class);
    }

    /* Helpers */

    public function totalQuantity()
    {
        return $this->items()->sum('quantity');
    }

    public function totalAmount()
    {
        return $this->items()->sum('subtotal');
    }
      // 🔥 THIS IS THE MOST IMPORTANT PART
    public function variant()
    {
        return $this->belongsTo(ProductVariant::class, 'variant_id');
    }

     /* Helpers */

    public function getSubtotalAttribute()
    {
        return $this->quantity * $this->price;
    }

    public function coupon()
{
    return $this->belongsTo(Coupon::class);
}

}
