<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'image',
        'icon',
        'short_description'
    ];

    // Override image attribute to return full URL
    
    // append full icon url
    protected $appends = ['icon_full'];

    protected $hidden = ['icon', 'image', 'pivot'];


    // App\Models\Category.php

    public function subCategories()
    {
        return $this->hasMany(SubCategory::class);
    }

    // This creates image_full field
    public function getImageFullAttribute()
    {
        if (!$this->image) {
            return null;
        }

        // If image already has http or https avoid duplicating
        if (str_starts_with($this->image, 'http')) {
            return $this->image;
        }

        return url($this->image);
    }

    // OPTIONAL — replace "image" in response with full URL
  

    protected $casts = [
        'image_full' => 'string'
    ];

    public function products()
    {
        return $this->hasMany(Product::class, 'category_id');
    }

     public function getIconFullAttribute()
    {
        if (!$this->icon) {
            return null;
        }

        if (str_starts_with($this->icon, 'http')) {
            return $this->icon;
        }

        return url($this->icon);
    }
}
