<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProjectItem extends Model
{
    protected $fillable = [
        'project_id',
        'area_id',
        'category',
        'product_id',
        'variant_id',
        'quantity',
        'notes'
    ];

    public function project()
    {
        return $this->belongsTo(Project::class);
    }
    public function product()
    {
        return $this->belongsTo(Product::class);
    }
    public function variant()
    {
        return $this->belongsTo(ProductVariant::class, 'variant_id');
    }


    public function area()
    {
        return $this->belongsTo(ProjectArea::class, 'area_id');
    }

    public function measurement()
    {
        return $this->hasOne(ProjectItemMeasurement::class);
    }

    public function curtain()
    {
        return $this->hasOne(ProjectItemCurtain::class);
    }

    public function mattress()
    {
        return $this->hasOne(ProjectItemMattress::class);
    }

    public function sofa()
    {
        return $this->hasOne(ProjectItemSofa::class);
    }

    public function wallpaper()
    {
        return $this->hasOne(ProjectItemWallpaper::class);
    }

    public function accessories()
    {
        return $this->hasOne(ProjectItemAccessories::class);
    }
}
