<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Services\PriceService;

class ProductVariant extends Model
{
    protected $fillable = [
        'product_id',
        'sku',
        'batch_no',
        'mrp',
        'offer_price',
        'unit',
        'dimensions',
        'color_name',
        'color_code',
        'material_or_fabric_composition',
        'gsm',
        'weight',
        'rub_count',
        'moq',
        'pattern',
        'design_repeat',
        'mattress_size_category',
        'mattress_length_inch',
        'mattress_width_inch',
        'mattress_thickness_inch',
    ];

    protected $casts = [
        'dimensions' => 'array',
    ];

    public function images()
    {
        return $this->hasMany(ProductImages::class);
    }

    public function stocks()
    {
        return $this->hasMany(Stock::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
    public function cartItems()
    {
        return $this->hasMany(CartItem::class, 'variant_id');
    }
    // App\Models\ProductVariant.php
    public function primaryImage()
    {
        return $this->hasOne(ProductImages::class, 'product_variant_id')
            ->where('is_primary', 1);
    }

//     public function getOfferPriceAttribute($value)
// {
//     return PriceService::rolePrice($value);
// }

}
