<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $table = 'products';
    protected $fillable = [
        'category_id',
        'subcategory_id',
        'name',
        'description',
        'master_catalogue_name',
        'master_catalogue_code',
        'features',
        'maintenance',
        'warranty_certification',
        'measurement',
        'is_active',

        // New Fields
        'visibility',
        'gst_percent',
        'gst_inclusive',
        'is_parent',
        'related_products',
        'cross_sell_products',
        'upsell_products',
        'is_featured',
        'seo_title',
        'seo_description',
        'search_keywords',
        'care_instructions',
        'fast_moving',
        'slow_moving',
        'average_rating',
        'review_count',
        'sample_purchase',
         // ✅ Mattress Fields
    'mattress_size_category',
    'mattress_length_inch',
    'mattress_width_inch',
    'mattress_thickness_inch',
    'sample_purchase_rate'
    ];
    // App\Models\Product.php

    protected $casts = [
        'related_products'    => 'array',
        'cross_sell_products' => 'array',
        'upsell_products'     => 'array',
    ];

    public function rooms()
    {
        // specify table name
        return $this->belongsToMany(Room::class, 'product_rooms', 'product_id', 'room_id');
    }

    public function tags()
    {
        return $this->belongsToMany(Tags::class, 'product_tags', 'product_id', 'tag_id');
    }



    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    // Product.php

    public function subCategory()
    {
        return $this->belongsTo(SubCategory::class, 'subcategory_id'); // match DB column
    }


    public function variants()
    {
        return $this->hasMany(ProductVariant::class);
    }

    public function primaryImage()
    {
        return $this->hasOne(ProductImages::class)->where('is_primary', 1);
    }

    public function reviews()
    {
        return $this->hasMany(ProductReview::class);
    }
    public function cartItems()
{
    return $this->hasMany(CartItem::class);
}

}
