<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\WholesaleEnquiry;
use App\Models\User;
class WholesaleEnquiryController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'full_name'    => 'required|string|max:255',
            'phone_number' => 'required|string|max:20',
            'place'        => 'nullable|string|max:255',
            'message'      => 'nullable|string'
        ]);

        $enquiry = WholesaleEnquiry::create($request->all());


        // 🔔 Admin Notification
     
            $admin = User::first();
            $adminId = $admin?->id;
            event(new \App\Events\SystemEvent([
                'type' => 'WholesaleEnquiry',
                'title'        => 'Wholesale Enquiry Request',
                'subject' => $enquiry,
                'message' => "New whole saleenquiry from  {$enquiry->full_name} ",
                'recipient_id' => $adminId, // Admin to notify
                'channels' => ['dashboard'],
            ]));

        return response()->json([
            'success' => true,
            'message' => 'Enquiry submitted successfully',
            'data'    => $enquiry
        ]);
    }
}
