<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
class NotificationController extends Controller
{

public function index()
{
    $notifications = auth()->user()
        ->notifications()
        ->latest()
        ->get();

    $grouped = [
        'today' => [],
        'yesterday' => [],
        'older' => []
    ];

    foreach ($notifications as $notification) {

        $date = Carbon::parse($notification->created_at);

        $item = [
            'id' => $notification->id,
            'title' => $notification->data['title'] ?? '',
            'message' => $notification->data['message'] ?? '',
            'time' => $date->diffForHumans(),
            'read' => !is_null($notification->read_at),
            'created_at' => $date->toDateTimeString(),
        ];

        if ($date->isToday()) {
            $grouped['today'][] = $item;
        } elseif ($date->isYesterday()) {
            $grouped['yesterday'][] = $item;
        } else {
            $grouped['older'][] = $item;
        }
    }

    return response()->json([
        'success' => true,
        'notifications' => $grouped
    ]);
}

    public function markAsRead($id)
    {
        $notification = auth()->user()
            ->notifications()
            ->where('id', $id)
            ->first();

        if ($notification) {
            $notification->update(['read_at' => now()]);
        }

        return response()->json(['success' => true]);
    }
    public function markAllRead()
    {
        auth()->user()
            ->unreadNotifications
            ->markAsRead();

        return response()->json(['success' => true]);
    }
    public function delete($id)
    {
        auth()->user()
            ->notifications()
            ->where('id', $id)
            ->delete();

        return response()->json(['success' => true]);
    }
    public function deleteAll()
    {
        auth()->user()
            ->notifications()
            ->delete();

        return response()->json(['success' => true]);
    }
}
