
<?php $__env->startSection('content'); ?>
<style>
    .slot-btn {
        margin-bottom: 10px;
    }



    .btn-n-active {
        background: #55ce63;
    }

    .slot-btn:hover {
        background: #fbd500;
    }

    .invoice-fields {
        margin-bottom: 15px;
    }

    .tab-content {
        padding-top: 11px;
    }

    .card-box {
        padding: 0px;
    }

    /* defines the animation */
    @-webkit-keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translate3d(0, 100%, 0);
        }

        to {
            opacity: 1;
            transform: none;
        }
    }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translate3d(0, 100%, 0);
        }

        to {
            opacity: 1;
            transform: none;
        }
    }

    .main {
        opacity: 0;
        -webkit-animation: fadeInUp 1s ease-in-out 0s forwards;
        animation: fadeInUp 1s ease-in-out 0s forwards;
    }

    .main>div {
        -webkit-animation-delay: 1s;
        animation-delay: 1s;
    }

    .card-middle-avatar a {
        display: contents;
    }


    .main-limit h4 {
        font-size: 15px;
    }

    .doctor-table-blk {
        margin-bottom: 40px;
    }

    .provider {
        height: 550px;
        overflow: auto;
    }

    .provider::-webkit-scrollbar-track {
        /* border: 1px solid black; */
        background-color: #F5F5F5;
    }

    .provider::-webkit-scrollbar {
        width: 10px;
        background-color: #091269;
    }

    .provider::-webkit-scrollbar-thumb {
        background-color: #091269;
    }

    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@200&display=swap');

    * {
        padding: 0;
        margin: 0;
    }

    .container {
        min-height: 100vh;
        display: flex;
        justify-content: center;
        align-items: center;
        /* background-color: #eee; */
    }

    .container .cardbox {
        height: 650px;
        /* width: 800px; */
        background-color: #fff;
        position: relative;
        box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
        font-family: 'Poppins', sans-serif;
        border-radius: 20px;
    }

    .container .cardbox .form {
        width: 100%;
        height: 100%;

        display: flex;
    }

    .container .cardbox .left-side {
        width: 35%;
        background-color: #091269;
        height: 100%;
        border-top-left-radius: 20px;
        border-bottom-left-radius: 20px;
        padding: 20px 30px;
        box-sizing: border-box;

    }

    /*left-side-start*/
    .left-heading {
        color: #fff;

    }

    .steps-content {
        margin-top: 30px;
        color: #fff;
    }

    .steps-content p {
        font-size: 12px;
        margin-top: 15px;
    }

    .progress-bar {
        list-style: none;
        /*color:#fff;*/
        /* margin-top: 30px; */
        font-size: 13px;
        font-weight: 700;
        counter-reset: container 0;
    }

    .progress-bar li {
        position: relative;
        margin-left: 40px;
        margin-top: 50px;
        counter-increment: container 1;
        color: #4f6581;
    }

    .progress-bar li::before {
        content: counter(container);
        line-height: 25px;
        text-align: center;
        position: absolute;
        height: 25px;
        width: 25px;
        border: 1px solid #4f6581;
        border-radius: 50%;
        left: -40px;
        top: -5px;
        z-index: 10;
        background-color: #304767;


    }


    .progress-bar li::after {
        content: '';
        position: absolute;
        height: 90px;
        width: 2px;
        background-color: #4f6581;
        z-index: 1;
        left: -27px;
        top: -70px;
    }


    .progress-bar li.active::after {
        background-color: #fff;

    }

    .progress-bar li:first-child:after {
        display: none;
    }

    /*.progress-bar li:last-child:after{*/
    /*  display:none;  */
    /*}*/
    .progress-bar li.active::before {
        color: #fbd500;
        border: 1px solid #fbd500;
    }

    .progress-bar li.active {
        color: #fff;
    }

    .d-none {
        display: none;
    }

    /*left-side-end*/
    .container .cardbox .right-side {
        width: 65%;
        background-color: #fff;
        height: 100%;
        border-radius: 20px;
    }

    /*right-side-start*/
    .main {
        display: none;
    }

    .active {
        display: block;
    }

    .main {
        padding: 40px;
    }

    .main small {
        display: flex;
        justify-content: center;
        align-items: center;
        margin-top: 2px;
        height: 30px;
        width: 30px;
        background-color: #ccc;
        border-radius: 50%;
        color: yellow;
        font-size: 19px;
    }

    .text {
        margin-top: 20px;
    }

    .congrats {
        text-align: center;
    }

    .text p {
        margin-top: 10px;
        font-size: 13px;
        font-weight: 700;
        color: #cbced4;
    }

    .input-text {
        margin: 30px 0;
        display: flex;
        gap: 20px;
    }

    .input-text .input-div {
        width: 100%;
        position: relative;

    }



    input[type="text"] {
        width: 100%;
        height: 40px;
        border: none;
        outline: 0;
        border-radius: 5px;
        border: 1px solid #cbced4;
        gap: 20px;
        box-sizing: border-box;
        padding: 0px 10px;
    }

    select {
        width: 100%;
        height: 40px;
        border: none;
        outline: 0;
        border-radius: 5px;
        border: 1px solid #cbced4;
        gap: 20px;
        box-sizing: border-box;
        padding: 0px 10px;
    }

    .input-text .input-div span {
        position: absolute;
        top: 10px;
        left: 10px;
        font-size: 14px;
        transition: all 0.5s;
    }

    .input-div input:focus~span,
    .input-div input:valid~span {
        top: -15px;
        left: 6px;
        font-size: 10px;
        font-weight: 600;
    }

    .input-div span {
        top: -15px;
        left: 6px;
        font-size: 10px;
    }

    .buttons button {
        height: 40px;
        width: 100px;
        border: none;
        border-radius: 5px;
        background-color: #0075ff;
        font-size: 12px;
        color: #fff;
        cursor: pointer;
        float: right;
    }

    .button_space {
        /* display: flex; */
        gap: 20px;

    }

    .button_space button:nth-child(2) {
        background-color: #fff;
        color: #000;
        border: 1px solid#000;
    }

    .user_cardbox {
        margin-top: 20px;
        margin-bottom: 40px;
        height: 200px;
        width: 100%;
        border: 1px solid #c7d3d9;
        border-radius: 10px;
        display: flex;
        overflow: hidden;
        position: relative;
        box-sizing: border-box;
    }

    .user_cardbox span {
        height: 80px;
        width: 100%;
        background-color: #dfeeff;
    }

    .circle {
        position: absolute;
        top: 40px;
        left: 60px;
    }

    .circle span {
        height: 70px;
        width: 70px;
        background-color: #fff;
        display: flex;
        justify-content: center;
        align-items: center;
        border: 2px solid #fff;
        border-radius: 50%;
    }

    .circle span img {
        width: 100%;
        height: 100%;
        border-radius: 50%;
        object-fit: cover;
    }

    .social {
        display: flex;
        position: absolute;
        top: 100px;
        right: 10px;
    }

    .social span {
        height: 30px;
        width: 30px;
        border-radius: 7px;
        background-color: #fff;
        border: 1px solid #cbd6dc;
        display: flex;
        justify-content: center;
        align-items: center;
        margin-left: 10px;
        color: #cbd6dc;

    }

    .social span i {
        cursor: pointer;
    }

    .heart {
        color: red !important;
    }

    .share {
        color: red !important;
    }

    .user_name {
        position: absolute;
        top: 110px;
        margin: 10px;
        padding: 0 30px;
        display: flex;
        flex-direction: column;
        width: 100%;

    }

    .user_name h3 {
        color: #4c5b68;
    }

    .detail {
        /*margin-top:10px;*/
        display: flex;
        justify-content: space-between;
        margin-right: 50px;
    }

    .detail p {
        font-size: 12px;
        font-weight: 700;

    }

    .detail p a {
        text-decoration: none;
        color: blue;
    }

    .checkmark__circle {
        stroke-dasharray: 166;
        stroke-dashoffset: 166;
        stroke-width: 2;
        stroke-miterlimit: 10;
        stroke: #7ac142;
        fill: none;
        animation: stroke 0.6s cubic-bezier(0.65, 0, 0.45, 1) forwards;
    }

    .checkmark {
        width: 56px;
        height: 56px;
        border-radius: 50%;
        display: block;
        stroke-width: 2;
        stroke: #fff;
        stroke-miterlimit: 10;
        margin: 10% auto;
        box-shadow: inset 0px 0px 0px #7ac142;
        animation: fill .4s ease-in-out .4s forwards, scale .3s ease-in-out .9s both;
    }

    .checkmark__check {
        transform-origin: 50% 50%;
        stroke-dasharray: 48;
        stroke-dashoffset: 48;
        animation: stroke 0.3s cubic-bezier(0.65, 0, 0.45, 1) 0.8s forwards;
    }

    @keyframes stroke {
        100% {
            stroke-dashoffset: 0;
        }
    }

    @keyframes scale {

        0%,
        100% {
            transform: none;
        }

        50% {
            transform: scale3d(1.1, 1.1, 1);
        }
    }

    @keyframes fill {
        100% {
            box-shadow: inset 0px 0px 0px 30px #7ac142;
        }
    }










    .warning {
        border: 1px solid red !important;
    }


    /*right-side-end*/
    @media (max-width:750px) {
        .container {
            height: scroll;


        }

        .container .cardbox {
            max-width: 350px;
            height: auto !important;
            margin: 30px 0;
        }

        .container .cardbox .right-side {
            width: 100%;

        }

        .input-text {
            display: block;
        }

        .input-text .input-div {
            margin-top: 20px;

        }

        .container .cardbox .left-side {

            display: none;
        }
    }
</style>

<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.appoinments')); ?>">Doctors </a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.view-appoinment', ['id' => $data->id])); ?>" id="redirecturl">Appoinments </a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Transfer Appoinment</li>
                    </ul>
                </div>

                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">

                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-heading">
                                            <h4>Transfer Appoinment</h4>
                                        </div>
                                    </div>


                                    <!-- <form method="post" action="<?php echo e(route('admin.save-transfer-appoinment')); ?>"> -->
                                    <form id="transfer_form" action="<?php echo e(route('admin.save-transfer-appoinment')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div class="col-12 col-md-12 col-xl-12">
                                                <div class="row text-center" id="search-div">
                                                </div>
                                            </div>
                                            <div class="doctor-table-blk mb-3">
                                                <h5>Select Date and Time</h5>
                                            </div>


                                            <div class="col-12 col-md-6 col-xl-6">
                                                <div class="form-group local-forms row">

                                                    <?php

                                                    $booking_date = str_replace('-', '/', $data->Appointment_Date);

                                                    $booking_date = date("d/m/Y", strtotime($booking_date));
                                                    ?>
                                                    <input class="form-control datetimepicker" name="booking_date" value="<?php echo e($booking_date); ?>" type="text" placeholder>
                                                    <input type="hidden" name="slot_id">
                                                    <input type="hidden" name="slot">
                                                    <input type="hidden" name="therapist_id">
                                                    <input type="hidden" name="appoinment_id" value="<?php echo e($data->id); ?>">
                                                </div>
                                                <div class="form-group local-forms row">
                                                    <button class="btn btn-info search_slot">Search Slots</button>
                                                </div>
                                            </div>

                                            <div class="col-sm-6 col-lg-6 col-xl-6 d-flex">
                                                <div class="row text-center" id="slot-div" style="width:100%;">

                                                </div>
                                            </div>



                                        </div>
                                        <!-- <div class="row m-t-20">
                                <div class=" col-12 col-md-12 col-xl-12">
                                    <div class="form-group local-forms">
                                        <label>Specialization<span class="login-danger">*</span></label>
                                        <input class="form-control" required name="tag" type="text">
                                    </div>
                                </div>
                            </div>-->
                                        <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                                            <button type="submit" class="btn btn-success ">Submit</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            // $("#js-loader").fadeIn(300);
            var service_id = "<?php echo $data->service->id; ?>";
            var therapist_id = "<?php echo $data->therapist_id; ?>";
            $.ajax({
                url: "<?php echo e(route('admin.search-therapist-for-transfer')); ?>",
                method: "GET",
                data: {
                    'service_id': service_id,
                    'therapist_id': therapist_id
                },
                success: function(result) {
                    //    $("#js-loader").fadeOut(300);
                    $('#search-div').append(result);
                }
            });


            // booking();
        });

        $(document).on('click', '.therapist', function(e) {
            e.preventDefault();

            therapist_id = $(this).data('id');
            $("#therapist-n-active" + therapist_id).css('background', '#eee');
            $("#therapist-n-active" + therapist_id).css('border', '2px solid #666');
            $("#therapist-n-active" + therapist_id).css('box - shadow', 'rgba(6, 24, 44, 0.4) 0 px 0 px 0 px 2 px, rgba(6, 24, 44, 0.65) 0 px 4 px 6 px - 1 px, rgba(255, 255, 255, 0.08) 0 px 1 px 0 px inset');
            $("input[name=therapist_id]").val(therapist_id);
            bookingDate = $("input[name=booking_date]").val();
            callmethod = "<?php echo $data->Appointment_Type; ?>";
            service = "<?php echo $data->service_id; ?>";
            therapist = therapist_id;
            slots(bookingDate, callmethod, service, therapist);
        });

        $(document).on('click', ".search_slot", function(e) {
            e.preventDefault();
            bookingDate = $("input[name=booking_date]").val();
            callmethod = "<?php echo $data->Appointment_Type; ?>";
            service = "<?php echo $data->service_id; ?>";
            therapist = $("input[name=therapist_id]").val();
            if (therapist)
                slots(bookingDate, callmethod, service, therapist);
            else
                alert("Please select a therapist");

        });

        function slots(bookingDate, callmethod, service, therapist) {
            $("#js-loader").fadeIn(300);
            $.ajax({
                url: "<?php echo e(route('admin.search-slots')); ?>",
                method: "GET",
                data: {
                    'bookingDate': bookingDate,
                    'therapist': therapist,
                    'service': service,
                    'callmethod': callmethod
                },
                success: function(result) {
                    $("#js-loader").fadeOut(300);
                    $("input[name=call_type]").val(callmethod);
                    $('#slot-div').html(result);
                    $('#slot-li').addClass('active');
                    $('#slot').addClass('active');
                    $('#consulation').removeClass('active');
                    // booking();
                }
            });

            $(document).on('click', ".slot-btn", function(e) {
                e.preventDefault();
                slot_id = $(this).data('id');
                slot = $(this).data('value');
                $(".slot-btn").removeClass("btn-n-active");
                $(this).addClass("btn-n-active");
                $("input[name=slot_id]").val(slot_id);
                $("input[name=slot]").val(slot);
            });

        }

        $('#transfer_form').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            var redirecturl = $('#redirecturl').attr('href');

            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();
                    if (data.status == true) {
                        toastr.success(data.msg);
                    } else {
                        toastr.error(data.msg);
                    }
                    window.location.href = redirecturl;
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });
    </script>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.dashboard-template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yellowcl/public_html/resources/views/admin/appoinment/transfer.blade.php ENDPATH**/ ?>