
<?php $__env->startSection('content'); ?>
<style>
    @media (min-width: 730px) {
        .daterangepicker.ltr .ranges {
            float: right !important;
        }
    }
</style>
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index-2.php">Dashboard </a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Admin Dashboard</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="good-morning-blk">
            <div class="row">
                <div class="col-md-6">
                    <div class="morning-user">
                        <?php
                        $hour = date('H');

                        if ($hour >= 20) {
                        $greetings = "Good Night";
                        } elseif ($hour > 17) {
                        $greetings = "Good Evening";
                        } elseif ($hour > 11) {
                        $greetings = "Good Afternoon";
                        } elseif ($hour < 12) { $greetings="Good Morning" ; } ?> <h2><?php echo e($greetings); ?>, <span><?php echo e(auth()->guard('admin')->user()->name); ?></span></h2>
                            <p>Have a nice day at work</p>
                    </div>
                </div>
                <div class="col-md-6 position-blk">
                    <div class="morning-img">
                        <img src="assets/img/morning-img-03.png" alt>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6 col-sm-6 col-lg-6 col-xl-3">
                <a href="<?php echo e(route('admin.appoinments')); ?>">
                    <div class="dash-widget">
                        <div class="dash-boxs comman-flex-center">
                            <img src="assets/img/icons/calendar.svg" alt>
                        </div>
                        <div class="dash-content dash-count">
                            <h4>Appointments</h4>
                            <h2><span class="counter-up"><?php echo e(count(App\Models\Appointments::all())); ?></span></h2>
                            <!-- <p><span class="passive-view"><i class="feather-arrow-up-right me-1"></i>40%</span> vs last month</p> -->
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-md-6 col-sm-6 col-lg-6 col-xl-3">
                <a href="<?php echo e(route('admin.therapist')); ?>">
                    <div class="dash-widget">
                        <div class="dash-boxs comman-flex-center">
                            <img src="assets/img/icons/profile-add.svg" alt>
                        </div>
                        <div class="dash-content dash-count">
                            <h4>Therapist</h4>
                            <h2><span class="counter-up"><?php echo e(count(App\Models\Therapist::all())); ?></span></h2>
                            <!-- <p><span class="passive-view"><i class="feather-arrow-up-right me-1"></i>20%</span> vs last month</p> -->
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-md-6 col-sm-6 col-lg-6 col-xl-3">
                <a href="<?php echo e(route('admin.users')); ?>">
                    <div class="dash-widget">
                        <div class="dash-boxs comman-flex-center">
                            <img src="assets/img/icons/menu-icon-03.svg" alt>
                        </div>
                        <div class="dash-content dash-count">
                            <h4>Clients</h4>
                            <h2><span class="counter-up"><?php echo e(count(App\Models\User::all())); ?></span></h2>
                            <!-- <p><span class="negative-view"><i class="feather-arrow-down-right me-1"></i>15%</span> vs last month</p> -->
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-md-6 col-sm-6 col-lg-6 col-xl-3">
                <a href="<?php echo e(route('admin.blogs')); ?>">
                    <div class="dash-widget">
                        <div class="dash-boxs comman-flex-center">
                            <img src="assets/img/icons/tag-icon-01.svg" alt>
                        </div>
                        <div class="dash-content dash-count">
                            <h4>Blogs</h4>
                            <h2><?php echo e(count(App\Models\Blog::all())); ?></h2>
                            <!-- <p><span class="passive-view"><i class="feather-arrow-up-right me-1"></i>30%</span> vs last month</p> -->
                        </div>
                    </div>
                </a>
            </div>
        </div>
        <?php
        $consultations = App\Models\Appointments::select(
        "Appointment_Date",
        DB::raw('COUNT(*) as click')
        )
        ->groupBy('Appointment_Date')
        ->orderBy('id', 'asc')->get();

        $result[] = ['Appointment_Date', 'Consulations'];
        foreach ($consultations as $key => $value) {
        $result[++$key] = [$value->Appointment_Date, (int)$value->click];
        }


        $incomes = App\Models\Appointments::select(
        "Appointment_Date",
        DB::raw('SUM(fee) as income')
        )
        ->groupBy('Appointment_Date')
        ->orderBy('id', 'asc')->get();

        $income[] = ['Appointment_Date', 'income'];
        foreach ($incomes as $key => $value) {
        $income[++$key] = [$value->Appointment_Date, (int)$value->income];
        }

        ?>
        <div class="row">
            <div class="col-12 col-md-12 col-lg-6 col-xl-6">
                <div class="card">
                    <div class="card-body">

                        <h4>Consultation Report</h4>
                        <div class="form-group mb-5" style="float:right;margin-top: -24px;">
                            <input type="text" class="form-control" id="reportrange" s>
                        </div>
                        <div id="barchart_material" class=" row mb-5 p-0" style="width: 100%; height: 500px;"></div>

                    </div>
                </div>
            </div>
            <div class="col-12 col-md-12 col-lg-6 col-xl-6 d-flex">
                <div class="card">
                    <div class="card-body">
                        <div class="chart-title patient-visit mb-0">
                            <h4>Income</h4>
                            <div class="form-group mb-0">
                                <input type="text" class="form-control" id="reportrange_income">
                            </div>
                        </div>
                        <div id="linechart" class=" row mb-5 p-0" style="width: 100%; height: 500px;"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12 col-md-12  col-xl-4">
                <div class="card top-departments">
                    <div class="card-header">
                        <h4 class="card-title mb-0 d-inline-block">Therapist List</h4>
                        <a href="<?php echo e(route('admin.therapist')); ?>" class="patient-views float-end">Show all</a>
                    </div>
                    <div class="card-body">
                        <?php $__currentLoopData = App\Models\Therapist::limit(7)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="activity-top">
                            <div class="activity-boxs comman-flex-center">
                                <img width="28" height="28" class="rounded-circle" src="<?php echo e(asset('assets/uploads/therapist/' . $item->image)); ?>" alt="">
                            </div>
                            <div class="departments-list">
                                <h4><?php echo e($item->full_name); ?></h4>
                                <p><?php echo e($item->providerCategory->name); ?></p>
                                <p><?php echo e($item->professional_credentials); ?>,<?php echo e($item->designation); ?></p>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </div>
            </div>
            <div class="col-12 col-md-12  col-xl-8">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title d-inline-block">Upcoming Appointments</h4> <a href="appointments.php" class="patient-views float-end">Show all</a>
                    </div>
                    <div class="card-body p-0 table-dash">
                        <div class="table-responsive">
                            <table class="table mb-0 border-0 datatable custom-table">
                                <thead>
                                    <tr>
                                        <th>Status</th>
                                        <th>Patient name</th>
                                        <th>Doctor</th>
                                        <th>Time</th>
                                        <th>Call Method</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php $__currentLoopData = App\Models\Appointments::where('Appointment_Date', '>=', date('Y-m-d'))->orderBy('Appointment_Date', 'DESC')->limit(10)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><button class="custom-badge" style="background:<?php echo e(statusColor($item->Appointment_Status)); ?>;"><?php echo e($item->Appointment_Status); ?></button></td>
                                        <td><?php echo e($item->user->First_Name); ?> <?php echo e($item->user->Last_Name); ?></td>
                                        <td class=" table-image appoint-doctor">
                                            <img width="28" height="28" class="rounded-circle" src="assets/img/profiles/avatar-02.jpg" alt>
                                            <h2><?php echo e($item->therapist->prefix); ?> <?php echo e($item->therapist->full_name); ?></h2>
                                        </td>
                                        <td class="appoint-time"><span><?php echo e(date('d M Y', strtotime($item->Appointment_Date))); ?> at </span><?php echo e($item->Appointment_Time); ?></td>
                                        <td><button class="custom-badge status-gray "><?php echo e(App\Models\CallMethods::where('id', $item->Appointment_Type)->pluck('name')->first()); ?></button></td>
                                        <td class="text-end">
                                            <div class="dropdown dropdown-action">
                                                <a href="#" class="action-icon dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-ellipsis-v"></i></a>
                                                <div class="dropdown-menu dropdown-menu-end">
                                                    <a class="dropdown-item" href="<?php echo e(route('admin.view-appoinment', ['id' => $item->id])); ?>"><i class="fa-solid fa-eye m-r-5"></i> View</a>

                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12 col-xl-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h4 class="card-title d-inline-block">Packages </h4> <a href="<?php echo e(route('admin.packages')); ?>" class="float-end patient-views">show all</a>
                    </div>
                    <div class="card-block table-dash">
                        <div class="table-responsive">
                            <table class="table border-0 custom-table comman-table datatable mb-0">
                                <thead>
                                    <tr>
                                        <th>
                                            <div class="form-check check-tables">
                                                <input class="form-check-input" type="checkbox" value="something">
                                            </div>
                                        </th>
                                        <th>Package Name</th>
                                        <th>Number of Sessions</th>
                                        <th>Start Date</th>
                                        <th>End Date</th>
                                        <th>Discount</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = App\Models\Package::limit(5)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <div class="form-check check-tables">
                                                <input class="form-check-input" type="checkbox" value="something">
                                            </div>
                                        </td>
                                        <td><?php echo e($item->title); ?></td>
                                        <td><?php echo e($item->no_of_sessions); ?></td>
                                        <td><?php echo e(date('d M Y', strtotime($item->start_date))); ?></td>
                                        <td><?php echo e(date('d M Y', strtotime($item->endt_date))); ?></td>
                                        <td><?php echo e($item->discount); ?></td>
                                        <td class="text-end">
                                            <div class="dropdown dropdown-action">
                                                <a href="#" class="action-icon dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-ellipsis-v"></i></a>
                                                <div class="dropdown-menu dropdown-menu-end">

                                                    <a class="dropdown-item" href="<?php echo e(route('admin.view-packages', ['slug' => $item->slug])); ?>"><i class="fa-solid fa-pen-to-square m-r-5"></i> View</a>
                                                    <a class="dropdown-item" href="<?php echo e(route('admin.edit-packages', ['slug' => $item->slug])); ?>"><i class="fa-solid fa-pen-to-square m-r-5"></i> Edit</a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <script type="text/javascript" src="//cdn.jsdelivr.net/jquery/1/jquery.min.js"></script>
    <script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <!-- <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap/3/css/bootstrap.css" /> -->

    <script type="text/javascript" src="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js"></script>
    <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>

    <script>
        $(function() {

            var income = "<?php echo
                            Js::from($income)
                            ?>";

            console.log(income);

            google.charts.load('current', {
                'packages': ['corechart']
            });

            google.charts.setOnLoadCallback(drawChart);

            function drawChart() {

                var data = google.visualization.arrayToDataTable(income);

                var options = {

                    title: 'Income Line Chart',

                    curveType: 'function',

                    legend: {
                        position: 'bottom'
                    }

                };

                var chart = new google.visualization.LineChart(document.getElementById('linechart'));

                chart.draw(data, options);

            }
            var start = moment().subtract(29, 'days');
            var end = moment();

            function cb(start, end) {
                $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
            }

            $('#reportrange').daterangepicker({
                startDate: start,
                endDate: end,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            cb(start, end);


            function cb(start, end) {
                $('#reportrange_income span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
            }

            $('#reportrange_income').daterangepicker({
                startDate: start,
                endDate: end,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            cb(start, end);
        });
        google.charts.load('current', {
            'packages': ['bar', 'corechart']
        });
        google.charts.setOnLoadCallback(drawChart);

        function drawChart() {
            var data = google.visualization.arrayToDataTable(<?php echo
                                                                Js::from($result)
                                                                ?>);

            var options = {
                chart: {
                    //   title: 'Consultation Report',
                    // subtitle: 'Appoinments',
                },
            };

            var chart = new google.charts.Bar(document.getElementById('barchart_material'));
            chart.draw(data, google.charts.Bar.convertOptions(options));
        }
        $('body').on('click', '.applyBtn', function(e) {
            e.preventDefault();
            var url = "<?php echo e(route('admin.filter-consultation-report')); ?>";
            var from = $('#reportrange').data('daterangepicker').startDate.format('YYYY-MM-DD');
            var to = $('#reportrange').data('daterangepicker').endDate.format('YYYY-MM-DD');

            var from_income = $('#reportrange_income').data('daterangepicker').startDate.format('YYYY-MM-DD');
            var to_income = $('#reportrange_income').data('daterangepicker').endDate.format('YYYY-MM-DD');

            var url2 = "<?php echo e(route('admin.filter-income-report')); ?>";
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'GET',
                url: url,
                data: {
                    from_date: from,
                    to_date: to
                },

                success: function(result) {
                    $("#js-loader").fadeOut();
                    var data = google.visualization.arrayToDataTable(result);

                    var options = {
                        chart: {
                            //  title: 'Consultation Report',
                            // subtitle: 'Appoinments',
                        },
                    };

                    var chart = new google.charts.Bar(document.getElementById('barchart_material'));
                    chart.draw(data, google.charts.Bar.convertOptions(options));
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err.data);
                }
            });

            $.ajax({
                type: 'GET',
                url: url2,
                data: {
                    from_date: from_income,
                    to_date: to_income
                },
                success: function(result) {
                    $("#js-loader").fadeOut();
                    var data = google.visualization.arrayToDataTable(result);
                    var options = {
                        title: 'Income',
                        curveType: 'function',
                        legend: {
                            position: 'bottom'
                        }
                    };
                    var chart = new google.visualization.LineChart(document.getElementById('linechart'));
                    chart.draw(data, options);
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err.data);
                }
            });
        });


        $(window).on("load", function() {

            var url = "<?php echo e(route('admin.filter-consultation-report')); ?>";
            var from = $('#reportrange').data('daterangepicker').startDate.format('YYYY-MM-DD');
            var to = $('#reportrange').data('daterangepicker').endDate.format('YYYY-MM-DD');

            var from_income = $('#reportrange_income').data('daterangepicker').startDate.format('YYYY-MM-DD');
            var to_income = $('#reportrange_income').data('daterangepicker').endDate.format('YYYY-MM-DD');

            var url2 = "<?php echo e(route('admin.filter-income-report')); ?>";
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'GET',
                url: url,
                data: {
                    from_date: from,
                    to_date: to
                },
                success: function(result) {
                    $("#js-loader").fadeOut();
                    var data = google.visualization.arrayToDataTable(result);

                    var options = {
                        chart: {
                            //  title: 'Consultation Report',
                            //  subtitle: 'Appoinments',
                        },
                    };

                    var chart = new google.charts.Bar(document.getElementById('barchart_material'));
                    chart.draw(data, google.charts.Bar.convertOptions(options));
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err.data);
                }
            });

            $.ajax({
                type: 'GET',
                url: url2,
                data: {
                    from_date: from_income,
                    to_date: to_income
                },
                success: function(result) {
                    $("#js-loader").fadeOut();
                    var data = google.visualization.arrayToDataTable(result);
                    var options = {
                        title: 'Income',
                        curveType: 'function',
                        legend: {
                            position: 'bottom'
                        }
                    };
                    var chart = new google.visualization.LineChart(document.getElementById('linechart'));
                    chart.draw(data, options);
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err.data);
                }
            });
        });
    </script>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.dashboard-template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\yc\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>