
<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item active">Order Therapist</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card card-table show-entire">
                    <div class="card-body">

                        <div class="page-table-header mb-2">
                            <div class="row align-items-center">
                                <div class="col">
                                    <div class="doctor-table-blk">
                                        <h3>Order Therapist</h3>
                                        <div class="doctor-search-blk">
                                            <div class="add-group">
                                                <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#add_blog_category" class="btn btn-primary add-pluss ms-2"><img src="<?php echo e(asset('assets/img/icons/plus.svg')); ?>" alt></a>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table border-0 custom-table comman-table mb-0" id="tags_table">
                                <thead>
                                    <tr>
                                        <th>
                                            #
                                        </th>
                                        <th>Therapist</th>
                                        <th>Order Number</th>
                                        <th>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="add_blog_category" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered ">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add Order Number</h5>

                </div>
                <div class="modal-body text-center">
                    <form class="tags_form" action="<?php echo e(route('admin.save-therapistOrder')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="row m-t-20">
                            <div class=" col-12 col-md-12 col-xl-12">
                                <div class="form-group local-forms">
                                    <label>Therapist<span class="login-danger">*</span></label>
                                    <?php
                                    $therapist = App\Models\Therapist::select('id', 'full_name')->whereNull('order_number')->orderBy('full_name', 'ASC')->get();

                                    ?>
                                    <select class="form-control select" name="therapist" required id="provider">
                                        <option>--Select Provider--</option>
                                        <?php $__currentLoopData = $therapist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value=" <?php echo e($item->id); ?>"><?php echo e($item->full_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row m-t-20">
                            <div class=" col-12 col-md-12 col-xl-12">
                                <div class="form-group local-forms">
                                    <label>Order<span class="login-danger">*</span></label>
                                    <input class="form-control" required name="order" type="number">
                                </div>
                            </div>
                        </div>
                        <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                            <button type="submit" class="btn btn-success ">ADD</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        $(function() {
            var table = $('#tags_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "<?php echo e(route('admin.get-therapistOrder')); ?>",
                columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                }, {
                    data: 'therapist',
                    name: 'therapist'
                }, {
                    data: 'rank',
                    name: 'rank'
                }, {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }, ],
                "select": {
                    'style': 'multi',
                    'selector': 'td:first-child' //only checkbox can select row 
                },
            });
        });


        $('.tags_form').submit(function(e) {
            e.preventDefault();

            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();

                    if (data.status == true) {
                        toastr.success(data.message);
                    } else {
                        toastr.error(data.message);
                    }
                      $('.table').DataTable().ajax.reload();
                    table.draw();
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        // Handle validation errors
                        var errors = xhr.responseJSON.errors;

                        $.each(errors, function(key, value) {
                            // Display the first error message for each field
                            toastr.error(value[0]);
                            $('#error-' + key).text(value[0]);
                        });
                    } else {
                        toastr.error(xhr);
                        console.error('An error occurred:', xhr);
                    }
                }

            });
        });
    </script>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.dashboard-template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yellowcl/public_html/resources/views/admin/therapist/rank-therapist.blade.php ENDPATH**/ ?>