<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\ServiceController;
use App\Http\Controllers\Admin\SlotController;
use App\Http\Controllers\Admin\PackageController;
use App\Http\Controllers\Admin\TherapistController;
use App\Http\Controllers\Admin\BlogController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\OfferController;
use App\Http\Controllers\Admin\CouponController;
use App\Http\Controllers\Admin\AppoinmentController;
use App\Http\Controllers\Admin\HomePageController;
use App\Http\Controllers\Admin\WalletController;
use App\Http\Controllers\Admin\AssessmentController;
use App\Http\Controllers\Admin\PodcastController;
use App\Http\Controllers\Admin\NotificationController;
use App\Http\Controllers\Admin\PushNotificationController;
use App\Http\Controllers\Admin\AdminUsersController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\ReportController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/privacy-policy', function () {
    return view('privacy-policy');
})->name('privacy-policy');
Route::get('account/verify/{token}', [AuthController::class, 'verifyAccount'])->name('verify');
Route::get('/download/invoice/{id}', [AppoinmentController::class, 'downloadInvoice'])->name('download-invoice');
Route::group(
    ['namespace' => 'Admin', 'as' => 'admin.'],
    function () {
        Route::get('/', function () {
            return view('admin.auth.login');
        })->name('login');
        Route::get('/forgot/password', function () {
            return view('admin.auth.forgot-password');
        })->name('forgot-password');
        Route::get('/reset/password/{token}', [AuthController::class, 'showResetPasswordForm'])->name('reset.password.get');
        Route::post('/login', [AuthController::class, 'checkLogin'])->name('check-login');
        Route::post('/send/reset/password', [AuthController::class, 'submitForgetPasswordForm'])->name('send-reset-password');
        Route::post('/save/new/password', [AuthController::class, 'saveNewPassword'])->name('save-new-password');

        Route::group(
            ['middleware' => ['auth:admin']],
            function () {
                Route::get('/send-notification', [NotificationController::class, 'sendAppoinmentNotification'])->name('send-notification');
                Route::post('/mark-as-read', [NotificationController::class, 'markNotification'])->name('markNotification');
                Route::get('/dashboard', function () {
                    return view('admin.dashboard');
                })->name('dashboard');
                Route::get('/logout', [AuthController::class, 'logout'])->name('logout');
                Route::post('/save/reset/password', [AuthController::class, 'changePassword'])->name('save-reset-password');
                Route::get('/reset-password', function () {
                    return view('admin.auth.reset-password');
                })->name('reset-password');
                //********************************** SERVICE SECTION *********************************/
                Route::get('/services', function () {
                    return view('admin.service.list');
                })->name('services');
                Route::get('/add/services', function () {
                    return view('admin.service.add');
                })->name('add-services');

                Route::post('/save/service', [ServiceController::class, 'saveService'])->name('save-service');
                Route::get('/fee-html', [ServiceController::class, 'feeHtml'])->name('fee-html');
                Route::get('/get/service', [ServiceController::class, 'getService'])->name('get-service');
                Route::post('/update/service', [ServiceController::class, 'updateService'])->name('update-service');
                Route::get('/edit/service', [ServiceController::class, 'editService'])->name('edit-service');
                Route::get('/delete/service', [ServiceController::class, 'deleteService'])->name('delete-service');
                Route::get('/delete/service/fee', [ServiceController::class, 'deleteServiceFee'])->name('delete-service-fee');
                Route::get('/change/service/status', [ServiceController::class, 'changeServiceStatus'])->name('change-service-status');
                Route::get('/service/{slug}', [ServiceController::class, 'viewService'])->name('view-service');
                Route::get('/load/service', [ServiceController::class, 'loadService'])->name('load-service');
                Route::get('/load/service/html', [ServiceController::class, 'loadServiceHtml'])->name('load-service-html');
                Route::get('/load/service/fee/html', [ServiceController::class, 'loadServiceFeeHtml'])->name('load-service-fee-html');
                Route::get('/load/callmethods/html', [ServiceController::class, 'loadCallMethodHtml'])->name('load-callmethods-html');
                //********************************** SERVICE SECTION END*********************************/

                //********************************** PACKAGE SECTION *********************************/
                Route::get('/packages', [PackageController::class, 'index'])->name('packages');
                Route::post('/save/package', [PackageController::class, 'savePackage'])->name('save-package');
                Route::get('/package/{slug}', [PackageController::class, 'viewPackage'])->name('view-packages');
                Route::get('/edit/package/{slug}', [PackageController::class, 'editPackage'])->name('edit-packages');
                Route::get('/delete/package', [PackageController::class, 'deletePackage'])->name('delete-package');
                Route::get('/add/package', function () {
                    return view('admin.packages.add');
                })->name('add-package');
                Route::get('/autocomplete', [PackageController::class, 'autocomplete'])->name('autocomplete');
                Route::post('/update/package', [PackageController::class, 'updatePackage'])->name('update-package');
                //********************************** PACKAGE SECTION END*********************************/

                //********************************** THERAPIST SECTION *********************************/
                Route::get('/add/therapist', function () {
                    return view('admin.therapist.add');
                })->name('add-therapist');
                Route::get('/therapist', function () {
                    return view('admin.therapist.list');
                })->name('therapist');
                // Route::get('/add/therapist', [TherapistController::class, 'addTherapist'])->name('add-therapist');
                Route::post('/save/therapist', [TherapistController::class, 'saveTherapist'])->name('save-therapist');
                Route::get('/work-html', [TherapistController::class, 'workHtml'])->name('work-html');
                Route::get('/email-exist', [TherapistController::class, 'emailExist'])->name('email-exist');
                Route::get('/mobile-exist', [TherapistController::class, 'mobileExist'])->name('mobile-exist');
                Route::get('/training-html', [TherapistController::class, 'trainingHtml'])->name('training-html');
                Route::get('/academics-html', [TherapistController::class, 'academicsHtml'])->name('academics-html');
                Route::get('/licensing-html', [TherapistController::class, 'licensingHtml'])->name('licensing-html');
                Route::get('/get/therapist', [TherapistController::class, 'getTherapist'])->name('get-therapist');
                Route::post('/update/therapist', [TherapistController::class, 'updateTherapist'])->name('update-therapist');
                Route::get('/edit/therapist/{slug}', [TherapistController::class, 'editTherapist'])->name('edit-therapist');
                Route::get('/delete/therapist', [TherapistController::class, 'deleteTherapist'])->name('delete-therapist');
                Route::get('/delete/therapist/work', [TherapistController::class, 'deleteTherapistWork'])->name('delete-therapist-work');
                Route::get('/delete/therapist/academic', [TherapistController::class, 'deleteTherapistAcademic'])->name('delete-therapist-academic');
                Route::get('/delete/therapist/training', [TherapistController::class, 'deleteTherapistTraining'])->name('delete-therapist-training');
                Route::get('/change/therapist/status', [TherapistController::class, 'changeTherapistStatus'])->name('change-therapist-status');
                Route::get('/delete/therapist/license', [TherapistController::class, 'deleteTherapistLicense'])->name('delete-therapist-license');
                Route::get('/therapist/{slug}', [TherapistController::class, 'viewTherapist'])->name('view-therapist');
                Route::get('/provider/category', [TherapistController::class, 'providerCategory'])->name('provider-category');
                Route::get('/featured/therapist/status', [TherapistController::class, 'featuredTherapistStatus'])->name('featured-therapist-status');
                Route::post('/reset/therapist/password', [TherapistController::class, 'resetTherapistPassword'])->name('reset-therapist-password');
                Route::get('/redirect/therapist/{id}', [TherapistController::class, 'editTherapistId'])->name('edit-therapist-id');

                Route::get('/specialization', function () {
                    return view('admin.home.specialization');
                })->name('specialization');
                Route::get('/earnings', function () {
                    return view('admin.therapist.earnings');
                })->name('earnings');
                Route::get('/settlement', function () {
                    return view('admin.therapist.settlement');
                })->name('settlement');
                Route::get('/add/settlement', function () {
                    return view('admin.therapist.add-settlement');
                })->name('add-settlement');
                Route::get('/get/earnings', [TherapistController::class, 'getearnings'])->name('get-earnings');
                Route::get('/get/settlement', [TherapistController::class, 'getSettlements'])->name('get-settlements');
                Route::get('/delete/settlement', [TherapistController::class, 'deleteSettlement'])->name('delete-settlement');
                Route::get('/edit/settlement/{id}', [TherapistController::class, 'editSettlement'])->name('edit-settlement');
                Route::post('/update/settlement', [TherapistController::class, 'updateSettlement'])->name('update-settlement');
                Route::post('/save/settlement', [TherapistController::class, 'saveSettlement'])->name('save-settlement');
                Route::post('/save/specialization', [TherapistController::class, 'saveSpecialization'])->name('save-specialization');
                Route::get('/get/specialization', [TherapistController::class, 'getSpecialization'])->name('get-specialization');
                Route::get('/delete/specialization', [TherapistController::class, 'deleteSpecialization'])->name('delete-specialization');

                Route::get('/tags', function () {
                    return view('admin.home.tags');
                })->name('tags');
                Route::post('/save/tags', [HomePageController::class, 'saveTags'])->name('save-tags');
                Route::get('/get/tags', [HomePageController::class, 'getTags'])->name('get-tags');
                Route::get('/delete/tags', [HomePageController::class, 'deleteTags'])->name('delete-tags');
                  Route::get('/test', [HomePageController::class, 'test'])->name('test');
                  

                Route::get('/order/therapist', function () {
                    return view('admin.therapist.rank-therapist');
                })->name('order-therapist');

                Route::post('/save/therapistOrder', [TherapistController::class, 'savetherapistOrder'])->name('save-therapistOrder');
                Route::get('/get/therapistOrder', [TherapistController::class, 'gettherapistOrder'])->name('get-therapistOrder');
                Route::get('/edit/therapistOrder', [TherapistController::class, 'edittherapistOrder'])->name('edit-therapistOrder');

                //********************************** THERAPIST SECTION END*********************************/

                //********************************** SLOT SECTION *********************************/
                Route::get('/add/leave', function () {
                    return view('admin.therapist.add-leave');
                })->name('add-leave');
                Route::get('/manage/leaves', function () {
                    return view('admin.therapist.leave');
                })->name('leave');
                Route::post('/save/leave', [SlotController::class, 'saveLeave'])->name('save-leave');
                Route::post('/update/leave', [SlotController::class, 'updateLeave'])->name('update-leave');
                Route::get('slots', function () {
                    return view('admin.slot.list');
                })->name('slots');

                Route::get('/delete/leave', [SlotController::class, 'deleteLeave'])->name('delete-leave');
                Route::get('/get/leaves', [SlotController::class, 'getLeaves'])->name('get-leaves');
                Route::get('/add/slot', [SlotController::class, 'addSlot'])->name('add-slot');
                Route::get('/edit/leave', [SlotController::class, 'editLeave'])->name('edit-leave');
                Route::get('/addMoreTime/html', [SlotController::class, 'addMoreTimeHTML'])->name('addMoreTime-html');
                Route::post('/save/slot', [SlotController::class, 'saveSlot'])->name('save-slot');
                Route::post('/update/slot', [SlotController::class, 'updateSlot'])->name('update-slot');
                Route::get('/get/slot', [SlotController::class, 'getSlot'])->name('get-slots');
                Route::get('/edit/slot', [SlotController::class, 'editSlot'])->name('edit-slot');
                Route::get('/view/slot', [SlotController::class, 'viewSlot'])->name('view-slot');
                Route::get('/delete/slot', [SlotController::class, 'deleteSlot'])->name('delete-slot');
                Route::get('/delete/slot/hour', [SlotController::class, 'deleteSlotHour'])->name('delete-slot-hour');
                Route::get('/load/slot/html', [SlotController::class, 'loadSlotHTml'])->name('load-slot-html');
                //********************************** SLOT SECTION END*********************************/

                //********************************** BLOG SECTION *********************************/

                Route::get('/blog/category', function () {
                    return view('admin.blog.category');
                })->name('blog-category');
                Route::get('/delete/blog/category', [BlogController::class, 'deleteBlogCategory'])->name('delete-blog-category');
                Route::get('/get/blog/category', [BlogController::class, 'getBlogCategory'])->name('get-blog-category');
                Route::post('/save/blog/category', [BlogController::class, 'saveBlogCategory'])->name('save-blog-category');
                Route::post('/update/blog/category', [BlogController::class, 'updateBlogCategory'])->name('update-blog-category');

                Route::post('/save/blog', [BlogController::class, 'saveBlog'])->name('save-blog');
                Route::get('/add/blog', function () {
                    return view('admin.blog.add');
                })->name('add-blog');
                Route::get('/blogs', function () {
                    return view('admin.blog.list');
                })->name('blogs');
                Route::get('/change/blog/status', [BlogController::class, 'changeBlogStatus'])->name('change-blog-status');
                Route::get('/delete/blog', [BlogController::class, 'deleteBlog'])->name('delete-blog');
                Route::get('/get/blog', [BlogController::class, 'getBlog'])->name('get-blog');
                Route::get('/edit/blog/{slug}', [BlogController::class, 'editBlog'])->name('edit-blog');
                Route::get('/view/blog/{slug}', [BlogController::class, 'viewBlog'])->name('view-blog');
                Route::post('/update/blog', [BlogController::class, 'updateBlog'])->name('update-blog');
                //********************************** BLOG SECTION END*********************************/

                //********************************** USER SECTION *********************************/
                Route::get('/add/user', function () {
                    return view('admin.user.add');
                })->name('add-user');
                Route::post('/save/user', [UserController::class, 'saveUser'])->name('save-user');
                Route::get('/users', function () {
                    return view('admin.user.list');
                })->name('users');
                Route::get('/import/users', function () {
                    return view('admin.user.import-users');
                })->name('import-users');
                Route::post('users-import', [UserController::class, 'import'])->name('users.import');
                Route::get('/change/user/status', [UserController::class, 'changeUserStatus'])->name('change-user-status');
                Route::get('/delete/user', [UserController::class, 'deleteUser'])->name('delete-user');
                Route::get('/get/user', [UserController::class, 'getUser'])->name('get-user');
                Route::get('/edit/user/{slug}', [UserController::class, 'editUser'])->name('edit-user');
                Route::get('/view/user/{slug}', [UserController::class, 'viewUser'])->name('view-user');
                Route::post('/update/user', [UserController::class, 'updateUser'])->name('update-user');
                Route::get('/delete/multiple/user', [UserController::class, 'deleteMultipleUser'])->name('delete-multiple-user');
                Route::get('/get/reviews', [UserController::class, 'getReviews'])->name('get-reviews');
                Route::get('/get/reviews/therapist', [UserController::class, 'getReviewsTherapist'])->name('get-reviews-therapist');
                Route::post('/add/wallet/amount', [WalletController::class, 'addWalletAmount'])->name('addWalletAmount');
                //********************************** USER SECTION END*********************************/

                //********************************** USER Appoinment*********************************/

                Route::get('/appoinments', function () {
                    return view('admin.appoinment.list');
                })->name('appoinments');
                Route::get('/check_payment_status/{id}', [AppoinmentController::class, 'checkPaymentStatus'])->name('check_payment_status');
                Route::get('/get/appoinment', [AppoinmentController::class, 'getAppoinments'])->name('get-appoinments');
                Route::get('/add/appoinment', [AppoinmentController::class, 'index'])->name('add-appoinment');
                Route::post('/save/appoinment', [AppoinmentController::class, 'saveAppoinment'])->name('save-appointment');
                Route::get('/search/therapist', [AppoinmentController::class, 'searchTherapist'])->name('search-therapist');
                Route::get('/search/therapist/service', [AppoinmentController::class, 'searchTherapistService'])->name('search-therapist-service');
                Route::get('/search/service/methods', [AppoinmentController::class, 'searchServiceMethods'])->name('search-service-methods');
                Route::get('/search/slots', [AppoinmentController::class, 'searchSlot'])->name('search-slots');
                // Route::get('/search/slots/with/date', [AppoinmentController::class, 'searchSlotWithDate'])->name('search-slots-with-date');
                Route::get('/payment/summary', [AppoinmentController::class, 'paymentSummary'])->name('payment-and-summary');
                Route::get('/search/user', [AppoinmentController::class, 'searchUser'])->name('search-user');
                Route::get('/appoinment/{id}', [AppoinmentController::class, 'viewAppoinment'])->name('view-appoinment');
                Route::get('/delete/appoinment', [AppoinmentController::class, 'deleteAppoinment'])->name('delete-appoinment');
                Route::get('/previuos/appoinments/{slug}', [AppoinmentController::class, 'previousAppoinments'])->name('previuos-appoinments');
                Route::get('/upcoming/appoinments/{slug}', [AppoinmentController::class, 'upcomingAppoinments'])->name('upcoming-appoinments');
                Route::get('/search/therapist/for/transfer', [AppoinmentController::class, 'searchTherapistForTherapist'])->name('search-therapist-for-transfer');
                Route::get('/transfer/appoinment/{id}', [AppoinmentController::class, 'transferAppoinments'])->name('transfer-appoinment');
                Route::get('/book/user/appoinment/{id}', [AppoinmentController::class, 'bookUserAppoinments'])->name('book-user-appoinment');
                Route::post('save/transfer/appoinment', [AppoinmentController::class, 'saveTransferAppoinments'])->name('save-transfer-appoinment');

                Route::get('/previous/appoinments/therapist/{id}', [AppoinmentController::class, 'previousAppoinmentsTherapist'])->name('previous-appoinments-therapist');
                Route::get('/upcoming/appoinments/therapist/{id}', [AppoinmentController::class, 'upcomingAppoinmentsTherapist'])->name('upcoming-appoinments-therapist');
                Route::get('/change/appoinment/status', [AppoinmentController::class, 'changeAppoinmentStatus'])->name('change-appoinment-status');
                Route::post('/reshedule/appoinment', [AppoinmentController::class, 'resheduleAppoinment'])->name('reshedule-appoinment');
                Route::get('/download/consultation/note/{id}', [AppoinmentController::class, 'downloadConsultationNote'])->name('download-consultation-note');
                Route::get('/download/prescription/note/{id}', [AppoinmentController::class, 'downloadPrescriptionNote'])->name('download-prescription-note');

                Route::post('/add/prescription', [AppoinmentController::class, 'addPrescription'])->name('add-prescription');
                Route::post('/add/consulation', [AppoinmentController::class, 'addConsulation'])->name('add-consulation');
                Route::get('/invoice/{id}', [AppoinmentController::class, 'invoice'])->name('invoice');
                //********************************** USER Appoinment*********************************/

                //********************************** Home Page Controller *********************************/
                Route::get('/thought-of-the-day', function () {
                    return view('admin.home.thoughts');
                })->name('thoughts-of-the-day');
                Route::post('/save/thoughts', [HomePageController::class, 'saveThoughts'])->name('save-thoughts');
                Route::get('/get/thoughts', [HomePageController::class, 'getThoughts'])->name('get-thoughts');
                Route::get('/delete/thoughts', [HomePageController::class, 'deleteThoughts'])->name('delete-thoughts');
                Route::get('/edit/thought/html', [HomePageController::class, 'editDeleteThoughts'])->name('edit-thought-html');
                Route::post('/update/thoughts', [HomePageController::class, 'updateThoughts'])->name('update-thoughts');

                //********************************** banner Controller *********************************/
                Route::get('/banners', function () {
                    return view('admin.home.banners');
                })->name('banners');
                Route::post('/save/banners', [HomePageController::class, 'saveBanners'])->name('save-banners');
                Route::get('/get/banners', [HomePageController::class, 'getBanners'])->name('get-banners');
                Route::get('/delete/banners', [HomePageController::class, 'deleteBanners'])->name('delete-banners');
                Route::post('/update/banners', [HomePageController::class, 'updateBanners'])->name('update-banners');

                Route::get('/video/banners', function () {
                    return view('admin.home.video-banners');
                })->name('video-banners');


                Route::get('/reported/issues', function () {
                    return view('admin.reported-issue');
                })->name('reported-issue');
                Route::get('/get/repoted/issues', [HomePageController::class, 'getReportedissue'])->name('get-repoted-issues');
                Route::get('/delete/repoted/issues', [HomePageController::class, 'deleteReport'])->name('delete-report');

                Route::post('/save/video/banners', [HomePageController::class, 'saveVideoBanners'])->name('save-video-banners');
                Route::get('/get/video/banners', [HomePageController::class, 'getVideoBanners'])->name('get-video-banners');
                Route::get('/delete/video/banners', [HomePageController::class, 'deleteVideoeBanners'])->name('delete-video-banners');
                //********************************** Home Page Controller end *********************************/

                //********************************** OFFER SECTION *********************************/
                Route::get('/offers', [OfferController::class, 'index'])->name('offers');
                Route::post('/save/offer', [OfferController::class, 'saveOffer'])->name('save-offer');
                Route::get('/view/offer/', [OfferController::class, 'viewOffer'])->name('view-offer');
                Route::get('/edit/offer/{slug}', [OfferController::class, 'editOffer'])->name('edit-offer');
                Route::get('/delete/offer', [OfferController::class, 'deleteOffer'])->name('delete-offer');
                Route::get('/add/offer', function () {
                    return view('admin.offer.add');
                })->name('add-offer');
                Route::get('/get/offer', [OfferController::class, 'getOffer'])->name('get-offer');
                Route::get('/change-offer-status', [OfferController::class, 'changeOfferStatus'])->name('change-offer-status');
                Route::post('/update/offer', [OfferController::class, 'updateOffer'])->name('update-offer');
                //********************************** OFFER SECTION END*********************************/

                //********************************** COUPON SECTION *********************************/
                Route::get('/coupons', [CouponController::class, 'index'])->name('coupons');
                Route::post('/save/coupons', [CouponController::class, 'saveCoupon'])->name('save-coupons');
                Route::get('/view/coupons/', [CouponController::class, 'viewCoupon'])->name('view-coupons');
                Route::get('/edit/coupons/{slug}', [CouponController::class, 'editCoupon'])->name('edit-coupons');
                Route::get('/delete', [CouponController::class, 'deleteCoupon'])->name('delete-coupons');
                Route::get('/add/coupons', function () {
                    return view('admin.coupons.add');
                })->name('add-coupons');
                Route::get('/get/coupons', [CouponController::class, 'getCoupons'])->name('get-coupons');
                Route::get('/change-coupons-status', [CouponController::class, 'changeCouponStatus'])->name('change-coupons-status');
                Route::post('/update/coupons', [CouponController::class, 'updateCoupon'])->name('update-coupons');
                //********************************** COUPON SECTION END*********************************/

                //********************************** Site configuration start *********************************/
                Route::get('/site/settings', [WalletController::class, 'index'])->name('configuration-settings');
                Route::post('/save/wallet/point', [WalletController::class, 'saveWalletPoint'])->name('save-wallet-point');
                Route::get('/get/wallet/log', [WalletController::class, 'getWalletPoints'])->name('get-wallet-log');
                Route::post('/save/wallet/commission', [WalletController::class, 'saveWalletCommission'])->name('save-wallet-commission');
                Route::get('/wallet/transactions/{slug}', [WalletController::class, 'walletTransactions'])->name('wallet-transactions');
                Route::post('/save/privacy/policy', [WalletController::class, 'savePrivacyPolicy'])->name('privacy-policy');
                Route::post('/save/term/conditions', [WalletController::class, 'saveTermCondition'])->name('terms-condition');
                Route::post('/save/contact/form', [WalletController::class, 'saveContact'])->name('contact-details');
                Route::post('/update/wallet/type', [WalletController::class, 'updateWalletType'])->name('update-wallet-type');
                //********************************** Site configuration start end *********************************/

                //********************************** Assessment *********************************/
                Route::get('/add/assessment', function () {
                    return view('admin.assessment.add');
                })->name('add-assessment');
                Route::get('/assessment', function () {
                    return view('admin.assessment.list');
                })->name('assessment');
                Route::get('/edit/assessment/{slug}', [AssessmentController::class, 'editAssessment'])->name('edit-assessment');
                Route::get('/get/assessment', [AssessmentController::class, 'getAssessment'])->name('get-assessment');
                Route::get('/view/assessment/{slug}', [AssessmentController::class, 'viewAssessment'])->name('view-assessment');
                Route::post('/save/assessment', [AssessmentController::class, 'saveAssessment'])->name('save-assessment');
                Route::get('/settings-html', [AssessmentController::class, 'settingsHtml'])->name('settings-html');
                Route::get('/answer-html', [AssessmentController::class, 'answerHtml'])->name('answer-html');
                Route::get('/delete/assesment', [AssessmentController::class, 'delete'])->name('delete-assesment');
                Route::get('/delete/multiple/assesment', [AssessmentController::class, 'deleteMultiple'])->name('delete-multiple-assesment');
                Route::get('/questions-html', [AssessmentController::class, 'questionsHtml'])->name('questions-html');
                Route::post('/update/assessment', [AssessmentController::class, 'updateAssessment'])->name('update-assessment');
                Route::post('/update/assessment/settings', [AssessmentController::class, 'updateAssessmentSettings'])->name('update-assessment-settings');
                Route::post('/update/assessment/QandA', [AssessmentController::class, 'updateAssessmentQandA'])->name('update-assessment-qanda');
                Route::get('/delete-question', [AssessmentController::class, 'deleteQuestion'])->name('delete-question');
                Route::get('/delete-answer', [AssessmentController::class, 'deleteAnswer'])->name('delete-answer');
                Route::get('/delete-setting', [AssessmentController::class, 'deleteSetting'])->name('delete-setting');
                Route::get('/get/user/assessment', [AssessmentController::class, 'getUserAssessment'])->name('get-user-assessment');
                Route::get('/get/assessment/list/{id}', [AssessmentController::class, 'getAssessmentList'])->name('get-assessment-list');
                //**********************************  Assessment *********************************/

                //********************************** PODCAST SECTION *********************************/


                Route::post('/save/podcast', [PodcastController::class, 'savePodcast'])->name('save-podcast');
                Route::get('/add/podcast', function () {
                    return view('admin.podcast.add');
                })->name('add-podcast');
                Route::get('/podcasts', function () {
                    return view('admin.podcast.list');
                })->name('podcasts');
                Route::get('/change/podcast/status', [PodcastController::class, 'changePodcastStatus'])->name('change-podcast-status');
                Route::get('/delete/podcast', [PodcastController::class, 'deletePodcast'])->name('delete-podcast');
                Route::get('/get/podcast', [PodcastController::class, 'getPodcast'])->name('get-podcast');
                Route::get('/edit/podcast/{slug}', [PodcastController::class, 'editPodcast'])->name('edit-podcast');

                Route::post('/update/podcast', [PodcastController::class, 'updatePodcast'])->name('update-podcast');
                //********************************** PODCAST SECTION END*********************************/

                //********************************** Push notification *********************************/
                Route::get('/sendNotification', [PushNotificationController::class, 'sendNotification'])->name('sendNotification');
                //********************************** Push notification *********************************/
                //********************************** admin users *********************************/

                Route::get('/roles', [RoleController::class, 'index'])->name('roles');
                Route::post('/save/role', [RoleController::class, 'saveRole'])->name('save-role');
                Route::post('/update/role', [RoleController::class, 'updateRole'])->name('update-role');
                Route::get('/get/role', [RoleController::class, 'getRole'])->name('get-role');
                Route::get('/edit/role', [RoleController::class, 'editRole'])->name('edit-role');
                Route::get('/delete/role', [RoleController::class, 'deleteRole'])->name('delete-role');
                // ***************** User roles
                Route::get('/add/panel/user', function () {
                    return view('admin.adminUser.add-user');
                })->name('add-admin-user');
                Route::get('/yellowcloud/users', function () {
                    return view('admin.adminUser.user-list');
                })->name('panel-users');
                Route::post('/save/user/role', [RoleController::class, 'saveUserRole'])->name('save-user-role');

                Route::post('/update/user/role', [RoleController::class, 'updateUserRole'])->name('update-user-role');
                Route::get('/panel/users', [RoleController::class, 'getUserRole'])->name('get-panel-user');
                Route::get('/edit/user/role/{slug}', [RoleController::class, 'editUserRole'])->name('edit-user-role');
                Route::get('/delete/user/role', [RoleController::class, 'deleteUserRole'])->name('delete-user-role');
                //********************************** admin users end *********************************/


                //********************************** report *********************************/
                Route::get('/wallet/report', function () {
                    return view('admin.report.wallet-commission');
                })->name('wallet-report');
                Route::get(
                    '/get/wallet/report',
                    [ReportController::class, 'getWalletReport']
                )->name('get-wallet-report');
                Route::get('/filter/income/report', [ReportController::class, 'graphfilterincome'])->name('filter-income-report');
                Route::get('/filter/consultation/report', [ReportController::class, 'graphfilter'])->name('filter-consultation-report');
                Route::get('/get/consultation/report', [ReportController::class, 'getConsultationReport'])->name('get-consulation-report');
                Route::get('/consultation/report', [ReportController::class, 'index'])->name('consultation-report');
                Route::get('/get/invoice/report', [ReportController::class, 'getInvoiceReport'])->name('get-invoice-report');
                Route::get('/payment/report', [ReportController::class, 'invoiceReport'])->name('invoice-report');
                Route::get('/get/patient/report', [ReportController::class, 'getpatientReport'])->name('get-patient-report');
                Route::get('/patient/report', [ReportController::class, 'patient'])->name('patient-report');

                //********************************** report end *********************************/
            }
        );
    }
);
