<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Therapist\LoginController;
use App\Http\Controllers\Therapist\AppoinmentController;
use App\Http\Controllers\Therapist\UserController;
use App\Http\Controllers\User\BlogController;
use App\Http\Controllers\Therapist\SlotController;
use App\Http\Controllers\User\BookingController;
use App\Http\Controllers\CallController;
use App\Http\Controllers\User\HomePageController;
use App\Http\Controllers\ChatController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::get('/privacy/policy', [HomePageController::class, 'privacy']);
Route::get('/terms/conditions', [HomePageController::class, 'terms']);
Route::get('/contacts', [HomePageController::class, 'contacts']);
Route::post('/send/forgot/password/mail', [UserController::class, 'sendForgotpswdMail']);
//********************************** therapist app *********************************/
Route::post('/login', [LoginController::class, 'login']);
Route::post('/follow/up/date', [AppoinmentController::class, 'followupdate']);
//********************************** therapist app end *********************************/
Route::middleware('auth:api-therapist')->group(function () {
  //********************************** therapist app *********************************/
  Route::get('/upcoming/appoinments/homepage', [LoginController::class, 'upcomingAppoinmentsHomePage']);
  Route::get('/thought-of-the-day', [LoginController::class, 'thoughts']);
  Route::get('/banners', [LoginController::class, 'banners']);
  Route::get('/reviews', [LoginController::class, 'reviews']);
  Route::get('/reviews/details', [LoginController::class, 'reviewDetails']);
  Route::get('/upcoming/appoinments', [AppoinmentController::class, 'upcomingAppoinments']);
  Route::get('/cancelled/appoinments', [AppoinmentController::class, 'cancelledAppoinments']);
  Route::get('/previous/appoinments', [AppoinmentController::class, 'previousAppoinments']);
  Route::post('/patient', [UserController::class, 'patient']);
  Route::post('/patient/details', [UserController::class, 'patientDetails']);
  Route::post('/assessment/QandA', [UserController::class, 'assessmentsQandA']);
  Route::get('/notification', [UserController::class, 'notification']);
  Route::get('/earnings', [UserController::class, 'earnings']);
  Route::get('/settlement', [UserController::class, 'getSettlements']);
  Route::post('/save/token', [UserController::class, 'saveToken'])->name('save-token-therapist');
  Route::get('/mood/listing', [UserController::class, 'moodListing']);
  Route::post('/reset/therapist/password', [UserController::class, 'resetTherapistPassword']);
  Route::post('/add/prescription', [AppoinmentController::class, 'addPrescription']);
  Route::post('/download/consultation', [AppoinmentController::class, 'downloadConsulation']);
  Route::post('/download/consultation/attachment', [AppoinmentController::class, 'downloadCousltationattachment']);
  Route::post('/download/prescription', [AppoinmentController::class, 'downloadPrescription']);
  Route::post('/add/consulation', [AppoinmentController::class, 'addConsulation']);
  Route::post('/add/blog', [LoginController::class, 'addBlog']);
  Route::post('/blogs', [LoginController::class, 'blog']);
  Route::get('/metrics', [UserController::class, 'metrics']);
  Route::post('/blog', [UserController::class, 'blogDetails']);
  Route::get('/blog/tags', [LoginController::class, 'blogTags']);
  Route::get('/blog/category', [LoginController::class, 'blogCategory']);
  Route::get('/package/appoinments', [AppoinmentController::class, 'packageAppoinments']);
  Route::get('/package/details', [UserController::class, 'packageDetails']);
  Route::get('/profile', [UserController::class, 'profile']);
  Route::get('/overview', [LoginController::class, 'overview']);

  Route::post('/logout', [LoginController::class, 'logout']);
  Route::get('/cancel/reason', [AppoinmentController::class, 'cancelReason']);
  //********************************** slot  *********************************/
  Route::get('/get/leave', [SlotController::class, 'getLeave']);
  Route::post('/save/leave', [SlotController::class, 'saveLeave']);
  Route::post('/save/slot', [SlotController::class, 'saveSlot']);
  Route::get('/slot', [SlotController::class, 'slot']);
  Route::post('/search/slot', [SlotController::class, 'searchSlot']);
  Route::post('/delete/slot/hour', [SlotController::class, 'deleteSlotHour']);
  Route::post('/change/appoinment/status', [AppoinmentController::class, 'changeAppoinmentStatus']);
  Route::post('/reshedule/appoinment', [BookingController::class, 'resheduleAppoinment']);
  Route::post('/report/an/issue', [UserController::class, 'reportAnIssue']);
  //********************************** slot end *********************************/
  //********************************** therapist app end *********************************/

  //********************************** call handle functions *********************************/


  Route::post('/save/call/logintime', [CallController::class, 'saveTherapistCallLoginTime']);
  Route::post('/save/call/logouttime', [CallController::class, 'saveTherapistCallLogoutTime']);
  //********************************** call handle functions end *********************************/

 //********************************** chat functions  *********************************/

 Route::post('/save/therapist/chat', [ChatController::class, 'saveTherapistChat']);
 Route::get('/get/therapist/chat', [ChatController::class, 'getTherapistChat']);
 //********************************** chat functions end *********************************/

});
