@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.users')}}">Patient</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Add Patient</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <!-- <form method="post" action="{{ route('admin.save-user') }}"> -->
                        <form id="add_user" action="{{ route('admin.save-user') }}">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Patient Details</h4>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>First Name <span class="login-danger">*</span></label>
                                        <input class="form-control" name="first_name" required type="text" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Last Name <span class="login-danger">*</span></label>
                                        <input class="form-control" name="last_name" required type="text" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Email <span class="login-danger">*</span></label>
                                        <input class="form-control" name="email" required type="email" placeholder>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="row">
                                        <label>Phone <span class="login-danger">*</span></label>
                                        <div class="col-3 col-md-3 col-xl-3">
                                            <div class="form-group local-forms">
                                                <input class="form-control" name="code" required type="text" placeholder="+91">
                                            </div>
                                        </div>
                                        <div class="col-9 col-md-9 col-xl-9">
                                            <div class="form-group local-forms">
                                                <input class="form-control" name="phone" required type="text" max="10">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group select-gender">
                                        <label class="gen-label">Gender<span class="login-danger">*</span></label>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="gender" aria-selected="" value="MALE" class="form-check-input">Male
                                            </label>
                                        </div>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="gender" value="FEMALE" class="form-check-input">Female
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms cal-icon">
                                        <label>Date Of Birth <span class="login-danger"></span></label>
                                        <input class="form-control datetimepicker" name="dob" type="text" placeholder>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">ADD USER</button>
                                        <button type="submit" class="btn btn-primary cancel-form">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $('#add_user').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(result) {
                    $("#js-loader").fadeOut();
                    if (result.status == true) {
                        toastr.success(result.data);
                        window.location.href = "{{ route('admin.users')}}";
                    } else if (result.status == false) {
                        toastr.error(result.data);
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err.data);
                }
            });
        });
    </script>
    @endsection