@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.therapist')}}">Therapists </a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Edit Therapist</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <!-- <form method="POST" action=" {{ route('admin.update-therapist') }}"> -->
                        <form id="addTherapist" action=" {{ route('admin.update-therapist') }}">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Therapist Details</h4>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="row">
                                        <div class="col-3 col-md-3 col-xl-3">
                                            <div class="form-group local-forms">
                                                <label>Full Name <span class="login-danger">*</span></label>

                                                <select class="form-control" name="prefix">
                                                    <option value="Mr." {{ $data->prefix =='Mr.' ? 'selected' : '' }}>Mr.</option>
                                                    <option value="Mrs." {{ $data->prefix =='Mrs.' ? 'selected' : '' }}>Mrs.</option>
                                                    <option value="Miss." {{ $data->prefix =='Miss.' ? 'selected' : '' }}>Miss.</option>
                                                    <option value="Ms." {{ $data->prefix =='Ms.' ? 'selected' : '' }}>Ms.</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-9 col-md-9 col-xl-9">
                                            <div class="form-group local-forms">
                                                <input type="hidden" name="id" value="{{$data->id}}">
                                                <input class="form-control" name="full_name" value="{{$data->full_name}}" type="text" placeholder>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Professional Credentials <span class="login-danger">*</span></label>
                                        <input class="form-control" name="professional_credentials" value="{{$data->professional_credentials}}" type="text" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Provider Category <span class="login-danger">*</span></label>

                                        <select class="form-control select" name="provider_category">
                                            @foreach(App\Models\ProviderCategory::get() as $item)
                                            <option value="{{$item->id}}" {{ $item->id == $data->provider_category_id ? 'selected' : '' }}>{{$item->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>


                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Service <span class="login-danger">*</span></label>
                                        <select class="form-control select chosen-select" multiple name="services[]">
                                            @foreach($data->services as $s)
                                            @php
                                            $service = App\Models\Service::where('id', $s)->first();
                                            @endphp
                                            <option value="{{$service->id}}" selected>{{$service->service_name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Qualification <span class="login-danger">*</span></label>
                                        <input class="form-control" name="qualification" value="{{$data->qualification}}" type="text" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-2">
                                    <div class="form-group local-forms">
                                        <label> Experience<span class="login-danger">*</span></label>
                                        <input class="form-control" name="experience" value="{{$data->experience}}" type="number" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-4">
                                    <div class="form-group local-forms">
                                        <label>Employee ID <span class="login-danger">*</span></label>
                                        <input class="form-control" name="employee_id" value="{{$data->employee_id}}" type="text" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Mobile <span class="login-danger">*</span></label>
                                        <input class="form-control" name="mobile" value="{{$data->mobile}}" type="text" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Email <span class="login-danger">*</span></label>
                                        <input class="form-control" name="email" value="{{$data->email}}" type="email" placeholder>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Designation <span class="login-danger">*</span></label>
                                        <input class="form-control" name="designation_in_yc" value="{{$data->designation}}" type="text" placeholder>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Languages Known<small>(separated with a comma)</small> <span class="login-danger">*</span></label>
                                        <input type="text" name="language_known" value="{{$data->language_known}}" data-role="tagsinput" class="form-control">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms cal-icon">
                                        <label>Date Of Birth <span class="login-danger">*</span></label>
                                        <input class="form-control datetimepicker" name="dob" type="text" placeholder value="{{date('d/m/y', strtotime($data->dob)) }}">
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-5">
                                    <div class="form-group local-top-form">
                                        <label class="local-top">Profile Image <span class="login-danger">*</span></label>
                                        <input type="file" accept="image/*" name="image" id="file" onchange="readURL(this);" class="form-control">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-1">
                                    <div class="form-group local-top-form">
                                        <img width="50" height="50" src="{{asset('assets/uploads/therapist/' . $data->image)}}" class="img-fluid call-imgs preview" alt="">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group select-gender">
                                        <label class="gen-label">Slot Managment permission<span class="login-danger">*</span></label>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="slot_managment" aria-selected="" value="on" class="form-check-input">On
                                            </label>
                                        </div>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="slot_managment" value="off" checked={{ $item->id == $data->slot_setting_permission ? "form-check-input" : "" }}> Off
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group select-gender">
                                        <label class="gen-label">Gender<span class="login-danger">*</span></label>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="gender" value="MALE" class="form-check-input" {{ $data->gender == 'MALE' ? 'checked' : ''}}>Male
                                            </label>
                                        </div>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="gender" value="FEMALE" class="form-check-input" {{ $data->gender == 'FEMALE' ? 'checked' : ''}}>Female
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms cal-icon">
                                        <label>Joining Date <span class="login-danger">*</span></label>
                                        <input class="form-control datetimepicker" value="{{date('d/m/y', strtotime($data->joining_date)) }}" name="joining_date" type="text" placeholder>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-12">
                                    <div class="form-group local-forms">
                                        @php
                                        $ids=$data->specialization_and_expertise;

                                        @endphp
                                        <label>Specialization and Expertise<small>(separated with a comma)</small> <span class="login-danger">*</span></label>
                                        <select class="form-control expertise" name="specialization_and_expertise[]" multiple="multiple">
                                            @foreach(App\Models\Specialization::get() as $item)
                                            @if(empty($ids))
                                            <option value="{{$item->id}}">{{$item->tag}}</option>
                                            @else
                                            @if(in_array($item->id, $ids))
                                            <option value="{{$item->id}}" selected>{{$item->tag}}</option>
                                            @else
                                            <option value="{{$item->id}}">{{$item->tag}}</option>
                                            @endif
                                            @endif
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Client Focus and Population<small>(separated with a comma)</small> <span class="login-danger"></span></label>
                                        <input type="text" name="client_focus_and_population" data-role="tagsinput" value="{{$data->client_focus_and_population}}" class="form-control">
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Address <span class="login-danger">*</span></label>
                                        <textarea class="form-control" name="address" rows="3" cols="30">{{$data->address}}</textarea>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group local-forms">
                                        <label>City <span class="login-danger">*</span></label>
                                        <input class="form-control" type="text" value="{{$data->city}}" name="city" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group local-forms">
                                        <label>State/Province <span class="login-danger">*</span></label>
                                        <input class="form-control" type="text" value="{{$data->state}}" name="state" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group local-forms">
                                        <label>Country <span class="login-danger">*</span></label>
                                        <input class="form-control" type="text" name="country" value="{{$data->country}}" placeholder>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group local-forms">
                                        <label>Postal Code <span class="login-danger">*</span></label>
                                        <input class="form-control" type="text" name="postal_code" value="{{$data->postal_code}}" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Profile Summary<span class="login-danger">*</span></label>
                                        <textarea class="form-control" rows="3" name="biography" cols="30">{{$data->biography}}</textarea>
                                    </div>
                                </div>


                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Personal Background <span class="login-danger"></span></label>
                                        <textarea class="form-control" rows="3" name="personal_background" cols="30">{{$data->personal_background}}</textarea>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Research and Publications <span class="login-danger"></span></label>
                                        <textarea class="form-control" rows="3" name="research_and_publications" cols="30">{{$data->research_and_publications}}</textarea>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Approach and Treatment Modalities <span class="login-danger"></span></label>
                                        <textarea class="form-control" rows="3" name="approach_and_treatment" cols="30">{{$data->approach_and_treatment}}</textarea>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Philosophy and Approach<span class="login-danger"></span></label>
                                        <textarea class="form-control" rows="3" name="philosophy_and_approach" cols="30">{{$data->philosophy_and_approach}}</textarea>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Awards <span class="login-danger"></span></label>
                                        <textarea class="form-control" rows="3" name="awards" cols="30">{{$data->awards}}</textarea>
                                    </div>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="card card-table show-entire">
                                        <div class="card-body">

                                            <div class="page-table-header mb-2">
                                                <div class="row align-items-center">
                                                    <div class="col">
                                                        <div class="doctor-table-blk">
                                                            <h3>Work Experience</h3>

                                                        </div>
                                                    </div>
                                                    <div class="col-auto text-end float-end ms-auto download-grp add-group">
                                                        <a href="javascript:void(0);" title="Add More Work Details" class="btn btn-primary add_work ms-2"><img src="{{asset('assets/img/icons/plus.svg')}}" alt></a>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                    </div>
                                </div>

                                @foreach($data->work as $key=>$item)
                                <div class="row" id="remove-work-row">
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Designation <span class="login-danger">*</span></label>
                                            <input class="form-control" value="{{$item->designation}}" name="designation[]" type="text" placeholder>
                                            <input type="hidden" name="work_id[]" value="{{$item->id}}">
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>Hospital<span class="login-danger">*</span></label>
                                            <input class="form-control" value="{{$item->hospital }}" name="hospital[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>Place <span class="login-danger">*</span></label>
                                            <input class="form-control" value="{{$item->place}}" name="place[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-1">
                                        <div class="add-group">
                                            <a href=" javascript:void(0);" id="remove_work" data-id="{{$item->id}}" class=" btn btn-primary ms-2"> <img src="{{asset('assets/img/icons/trash.svg')}}" alt> </a>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                                <div id="more-experience"></div>

                            </div>

                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="card card-table show-entire">
                                        <div class="card-body">

                                            <div class="page-table-header mb-2">
                                                <div class="row align-items-center">
                                                    <div class="col">
                                                        <div class="doctor-table-blk">
                                                            <h3>Academics Experience</h3>

                                                        </div>
                                                    </div>
                                                    <div class="col-auto text-end float-end ms-auto download-grp add-group">
                                                        <a href="javascript:void(0);" title="Add More Academic Details" class="btn btn-primary add_academics ms-2"><img src="{{asset('assets/img/icons/plus.svg')}}" alt></a>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                    </div>
                                </div>

                                @foreach($data->academics as $key=>$item)
                                <div class="row" id="remove-academics-row">
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Education <span class="login-danger">*</span></label>
                                            <input class="form-control" value="{{$item->education}}" name="education[]" type="text" placeholder>
                                            <input type="hidden" name="academic_id[]" value="{{$item->id}}">
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>College/University<span class="login-danger">*</span></label>
                                            <input class="form-control" value="{{$item->college}}" name="college[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>Year <span class="login-danger">*</span></label>
                                            <input class="form-control" value="{{$item->year}}" name="year[]" type="text">
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-1">
                                        <div class="add-group">
                                            <a href=" javascript:void(0);" id="remove_academics" data-id="{{$item->id}}" class=" btn btn-primary ms-2"> <img src="{{asset('assets/img/icons/trash.svg')}}" alt> </a>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                                <div id="more-academics"></div>
                            </div>

                            <!-- @if(!empty($data->license)) -->

                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="card card-table show-entire">
                                        <div class="card-body">

                                            <div class="page-table-header mb-2">
                                                <div class="row align-items-center">
                                                    <div class="col">
                                                        <div class="doctor-table-blk">
                                                            <h3> Licensing and Certifications</h3>
                                                        </div>
                                                    </div>
                                                    <div class="col-auto text-end float-end ms-auto download-grp add-group">
                                                        <a href="javascript:void(0);" title="Add More  Licensing and Certifications Details" class="btn btn-primary add_licensing ms-2"><img src="{{asset('assets/img/icons/plus.svg')}}" alt></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @foreach($data->license as $key=>$item)

                                <div class="row" id="remove_licensing-row">
                                    <div class="col-12 col-md-6 col-xl-6">
                                        <div class="form-group local-forms">
                                            <label> Licensing and Certifications Name <span class="login-danger"></span></label>
                                            <input class="form-control" name="licensing_and_certifications_name[]" value="{{$item->name}}" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-5">
                                        <div class="form-group local-forms">
                                            <label>Expiry Date<span class="login-danger"></span></label>
                                            <input type="hidden" name="license_id[]" value="{{$item->id}}">
                                            <input class="form-control datetimepicker" name="expiry_date[]" value="{{date('d/m/y', strtotime($item->date)) }}" type="text" placeholder>
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-xl-1">
                                        <div class="add-group">
                                            <a href="javascript:void(0);" id="remove_licensing" data-id="{{$item->id}}" class=" btn btn-primary ms-2"> <img src="{{asset('assets/img/icons/trash.svg')}}" alt> </a>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                                <div id="more-licensing"></div>
                            </div>

                            <!-- @endif -->
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="card card-table show-entire">
                                        <div class="card-body">

                                            <div class="page-table-header mb-2">
                                                <div class="row align-items-center">
                                                    <div class="col">
                                                        <div class="doctor-table-blk">
                                                            <h3>Additional Training</h3>

                                                        </div>
                                                    </div>
                                                    <div class="col-auto text-end float-end ms-auto download-grp add-group">
                                                        <a href="javascript:void(0);" title="Add More Academic Details" class="btn btn-primary add_training ms-2"><img src="{{asset('assets/img/icons/plus.svg')}}" alt></a>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                    </div>
                                </div>

                                @foreach($data->training as $key=>$item)
                                <div class="row" id="remove-training-row">
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Education <span class="login-danger">*</span></label>
                                            <input class="form-control" value="{{$item->education}}" name="training_education[]" type="text" placeholder>
                                            <input type="hidden" name="training_id[]" value="{{$item->id}}">
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>College/University<span class="login-danger">*</span></label>
                                            <input class="form-control" value="{{$item->college}}" name="training_college[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>Year <span class="login-danger">*</span></label>
                                            <input class="form-control" value="{{$item->year}}" name="training_year[]" type="text">
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-1">
                                        <div class="add-group">
                                            <a href=" javascript:void(0);" id="remove_training" data-id="{{$item->id}}" class=" btn btn-primary ms-2"> <img src="{{asset('assets/img/icons/trash.svg')}}" alt> </a>
                                        </div>
                                    </div>
                                </div>
                                @endforeach

                                <div id="more-trainings"></div>
                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">Submit</button>
                                        <button type="submit" class="btn btn-primary cancel-form">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

</div>
<script>
    $(".expertise").select2({
        multiple: true
    });
    $('body').on('click', '.add_training', function(e) {
        e.preventDefault();
        $("#js-loader").fadeIn();
        $.ajax({
            url: "{{ route('admin.training-html') }}",
            method: "GET",
            success: function(result) {
                $("#js-loader").fadeOut();
                $('#more-trainings').append(result);
            }
        });
    });
    $('body').on('click', '#remove_licensing', function(e) {
        var id = $(this).data('id');

        e.preventDefault();
        if (id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('admin.delete-therapist-license') }}",
                method: "GET",
                data: {
                    'id': id
                },
                success: function(result) {

                    if (result == 1) {
                        toastr.success("Row Deleted Successfully.");
                    } else {
                        toastr.error("Something went wrong.");
                    }


                }
            });
        }
        $(this).closest("#remove_licensing-row").remove();
    });
    $('body').on('click', '.add_licensing', function(e) {
        e.preventDefault();
        $("#js-loader").fadeIn();
        $.ajax({
            url: "{{ route('admin.licensing-html') }}",
            method: "GET",
            success: function(result) {
                $("#js-loader").fadeOut();
                $('#more-licensing').append(result);
            }
        });
    });
    $('body').on('click', '#remove_training', function(e) {
        var id = $(this).data('id');

        e.preventDefault();
        if (id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('admin.delete-therapist-training') }}",
                method: "GET",
                data: {
                    'id': id
                },
                success: function(result) {

                    if (result == 1) {
                        toastr.success("Row Deleted Successfully.");
                    } else {
                        toastr.error("Something went wrong.");
                    }


                }
            });
        }
        $(this).closest("#remove-training-row").remove();
    });


    $('select[name="provider_category"]').on('change', function() {
        var catId = $(this).val();
        if (catId) {
            $.ajax({
                url: "{{ route('admin.load-service') }}",
                data: {

                    'id': catId
                },
                type: "GET",
                //  dataType: "json",
                success: function(data) {
                    if (data != '') {
                        $('select[name="services[]"]').empty();
                        $('select[name="services[]"]').append('<option  value=""> --select service-- </option>');
                        $.each(data, function(key, value) {
                            $('select[name="services[]"]').append('<option value=" ' + value.id + '">' + value.service_name + '</option>');
                        })
                    } else {
                        $('select[name="services[]"]').empty();
                    }
                }

            })
        }
    });
    $(".chosen-select").select2({
        multiple: true
    });

    $('body').on('click', '.add_work', function(e) {
        e.preventDefault();
        $("#js-loader").fadeIn();
        $.ajax({
            url: "{{ route('admin.work-html') }}",
            method: "GET",
            success: function(result) {
                $("#js-loader").fadeOut();
                $('#more-experience').append(result);
            }
        });
    });

    $('body').on('click', '#remove_work', function(e) {
        var id = $(this).data('id');

        e.preventDefault();
        if (id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('admin.delete-therapist-work') }}",
                method: "GET",
                data: {
                    'id': id
                },
                success: function(result) {

                    if (result == 1) {
                        toastr.success("Row Deleted Successfully.");
                    } else {
                        toastr.error("Something went wrong.");
                    }


                }
            });
        }
        $(this).closest("#remove-work-row").remove();
    });

    $('body').on('click', '.add_academics', function(e) {
        e.preventDefault();
        $("#js-loader").fadeIn();
        $.ajax({
            url: "{{ route('admin.academics-html') }}",
            method: "GET",
            success: function(result) {
                $("#js-loader").fadeOut();
                $('#more-academics').append(result);
            }
        });
    });

    $('body').on('click', '#remove_academics', function(e) {
        var id = $(this).data('id');

        e.preventDefault();
        if (id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('admin.delete-therapist-academic') }}",
                method: "GET",
                data: {
                    'id': id
                },
                success: function(result) {

                    if (result == 1) {
                        toastr.success("Row Deleted Successfully.");
                    } else {
                        toastr.error("Something went wrong.");
                    }


                }
            });
        }
        $(this).closest("#remove-academics-row").remove();
    });

    $('#addTherapist').submit(function(e) {
        e.preventDefault();
        var url = $(this).attr("action");
        $("#js-loader").fadeIn();
        let formData = new FormData(this);
        $.ajax({
            type: 'POST',
            url: url,
            data: formData,
            contentType: false,
            processData: false,
            success: function(data) {

                $("#js-loader").fadeOut();
                if (data == true) {
                    toastr.success('Therapist Details Updated Successfully');
                    window.location.href = "{{ route('admin.edit-therapist-id', ['id' => $data->id]) }}";
                } else {
                    toastr.error('Something went wrong');
                }
            },
            error: function(err) {
                // Your Error Message
                toastr.error(err);
            }
        });
        $("#addTherapist").load(" #addTherapist > *");

    });
</script>
@endsection