@extends('admin.layout.dashboard-template')
@section('content')

<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.services')}}">Service</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Add Services</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <form id="addService" action=" {{ route('admin.save-service') }}">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Service Details</h4>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Service Title <span class="login-danger">*</span></label>
                                        <input class="form-control" name="title" type="text" placeholder>
                                    </div>
                                </div>
                                <!-- <div class="col-12 col-md-6 col-xl-4">
                                    <div class="form-group local-forms">
                                        <label>Duration <span class="login-danger">*</span></label>
                                        <input class="form-control" name="sessions" type="time" placeholder>
                                    </div>
                                </div> -->

                                <div class="col-12 col-md-6 col-xl-4">
                                    <div class="form-group local-top-form">
                                        <label class="local-top">Service Image <span class="login-danger">*</span></label>
                                        <!-- <div class="settings-btn upload-files-avator"> -->
                                        <input type="file" accept="image/*" name="image" id="file" onchange="readURL(this);" class="form-control">
                                        <!-- <label for="file" class="upload">Choose File</label> -->
                                        <!-- </div> -->
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-2">
                                    <div class="form-group local-top-form">
                                        <img width="100" height="80" src="{{asset('assets/img/no-image-available.jpg')}}" class="preview" alt="">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-12">
                                    <div class="form-group summer-mail">
                                        <label>Description <span class="login-danger">*</span></label>
                                        <textarea rows="4" name="description" cols="5" class="form-control summernote" placeholder="Enter your message here"></textarea>
                                    </div>
                                </div>


                            </div>

                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="card card-table show-entire">
                                        <div class="card-body">

                                            <div class="page-table-header mb-2">
                                                <div class="row align-items-center">
                                                    <div class="col">
                                                        <div class="doctor-table-blk">
                                                            <h3>Set Fee for Service</h3>

                                                        </div>
                                                    </div>
                                                    <div class="col-auto text-end float-end ms-auto download-grp add-group">
                                                        <a href="javascript:void(0);" title="Add more fee details" class="btn btn-primary add ms-2"><img src="{{asset('assets/img/icons/plus.svg')}}" alt></a>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                    </div>
                                </div>

                                <div class="fee-box row" id="remove-row">
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Provider Category <span class="login-danger">*</span></label>

                                            <select class="form-control select" name="provider_category[]">
                                                @foreach(App\Models\ProviderCategory::get() as $item)
                                                <option value="{{$item->id}}">{{$item->name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Call Method<span class="login-danger">*</span></label>
                                            <select class="form-control select" name="call_method[]">
                                                @foreach(App\Models\CallMethods::orderBy('id','DESC')->get() as $item)
                                                <option value="{{$item->id}}">{{$item->name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Duration (in mins)<span class="login-danger">*</span></label>
                                            <input class="form-control" name="duration[]" type="number">
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-2">
                                        <div class="form-group local-forms">
                                            <label>Rate<span class="login-danger">*</span></label>
                                            <input class="form-control" name="rate[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-1">
                                        <div class="add-group">
                                            <a href=" javascript:void(0);" id="remove" class=" btn btn-primary ms-2"> <img src="{{asset('assets/img/icons/trash.svg')}}" alt> </a>
                                        </div>
                                    </div>
                                </div>
                                <div id="more-fee"></div>

                            </div>


                            <div class="row">
                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">Save</button>
                                        <button type="submit" class="btn btn-primary cancel-form">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $('body').on('click', '.add', function(e) {
            e.preventDefault();
            $("#js-loader").fadeIn();
            $.ajax({
                url: "{{ route('admin.fee-html') }}",
                method: "GET",
                success: function(result) {
                    $("#js-loader").fadeOut();
                    $('#more-fee').append(result);
                }
            });
        });


        $('body').on('click', '#remove', function(e) {
            $(this).closest("#remove-row").remove();
            // $('#remove-row').hide('slow');
        });

        // $('body').on('change', '#call_method', function(e) {
        //     $(this).closest("#remove-row").remove();
        //     // $('#remove-row').hide('slow');
        // });

        $('#addService').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            $("#js-loader").fadeIn();
            let formData = new FormData(this);
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Service Added Successfully');
                    } else {
                        toastr.error('Something went Wrong');
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });
    </script>
    @endsection