@extends('admin.layout.dashboard-template')
@section('content')
<style>
    @media (min-width: 730px) {
        .daterangepicker.ltr .ranges {
            float: right !important;
        }
    }
</style>
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <!-- <li class="breadcrumb-item"><a href="admin-users.php">Service </a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li> -->
                        <li class="breadcrumb-item active">Consulation Report</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card card-table show-entire">
                    <div class="card-body">
                        <div class="page-table-header mb-5">
                            <div class="row align-items-center">
                                <div class="col">
                                    <div class="doctor-table-blk">
                                        <h3>Consulation Report</h3><br>
                                    </div>
                                    <!-- <div class="col"> -->
                                    <div class="col-md-5 offset-md-6 form-group mb-0" style="float:right;margin-right: 24px;">
                                        <label>Filter Graph by Date</label>
                                        <input type="text" class="form-control" id="reportrange">
                                    </div>
                                    <div id="barchart_material" class=" row mb-5 p-4" style="width: 100%; height: 500px;"></div>
                                    <!-- </div> -->
                                </div>

                            </div>
                        </div>
                        <div class="row align-items-center">

                            <div>
                                <div class=" row mb-5 p-2">

                                    <div class="col-12 col-md-6 col-xl-2">
                                        <div class="form-group local-forms">
                                            <label>From </label>
                                            <input class="form-control" type="date" required name="from" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-2">
                                        <div class="form-group local-forms">
                                            <label>To</label>
                                            <input class="form-control" type="date" required name="to" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-2">
                                        <div class="form-group local-forms">
                                            <label>Provider </label>
                                            <select class="form-control therapist" name="therapist">
                                                <option value="">--Select Therapist--</option>
                                                @foreach(App\Models\Therapist::get() as $item)
                                                <option value="{{$item->id}}">{{$item->prefix}}.{{$item->full_name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-2">
                                        <div class="form-group local-forms">
                                            <label>Appointment Status </label>
                                            <select class="form-control therapist" name="status">
                                                <option value="">--Select Status--</option>
                                                @foreach(status() as $item)
                                                <option value="{{$item}}">{{$item}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-2">
                                        <div class="form-group local-forms">
                                            <label>Package </label>
                                            <select class="form-control therapist" name="package">
                                                <option value="">--Select Package--</option>
                                                @foreach(App\Models\Package::get() as $item)
                                                <option value="{{$item->id}}">{{$item->title}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-xl-2">
                                        <div class="form-group local-forms">
                                            <!-- <button class="btn btn-success submit-form ">Filter</button> -->
                                            <button class="btn btn-success filter" style="width:100%;">Filter</button>
                                        </div>
                                    </div>

                                </div>


                                <div class="table-responsive">
                                    <table class="table border-0 custom-table comman-table mb-0" id="therapist_table">
                                        <thead>
                                            <tr>
                                                <th>Invoice No</th>
                                                <th>Invoice Date</th>
                                                <th>PID</th>
                                                <th>Patient<br> Name</th>
                                                <th>Therapist</th>
                                                <th>Appointment Date</th>
                                                <th>Appointment Status</th>
                                                <th>Call Type</th>
                                                <th>Fee(in Inr)</th>
                                            </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div id="delete_patient" class="modal fade delete-modal" role="dialog">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-body text-center">
                            <img src="assets/img/sent.png" alt width="50" height="46">
                            <h3>Are you sure want to delete this ?</h3>
                            <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                                <button type="submit" class="btn btn-danger" id="delete_item">Delete</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <script type="text/javascript" src="//cdn.jsdelivr.net/jquery/1/jquery.min.js"></script>
            <script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
            <!-- <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap/3/css/bootstrap.css" /> -->

            <script type="text/javascript" src="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js"></script>
            <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />
            <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
            <script type="text/javascript">
                $(function() {

                    var start = moment().subtract(29, 'days');
                    var end = moment();

                    function cb(start, end) {
                        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
                    }

                    $('#reportrange').daterangepicker({
                        startDate: start,
                        endDate: end,
                        ranges: {
                            'Today': [moment(), moment()],
                            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                            'This Month': [moment().startOf('month'), moment().endOf('month')],
                            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                        }
                    }, cb);

                    cb(start, end);

                    var table = $('#therapist_table').DataTable({
                        "footerCallback": function(row, data, start, end, display) {
                            var api = this.api(),
                                data;

                            // converting to interger to find total
                            var intVal = function(i) {
                                return typeof i === 'string' ?
                                    i.replace(/[\$,]/g, '') * 1 :
                                    typeof i === 'number' ?
                                    i : 0;
                            };

                            var thuTotal = api
                                .column(8)
                                .data()
                                .reduce(function(a, b) {
                                    return intVal(a) + intVal(b);
                                }, 0);

                            // var friTotal = api
                            //     .column(5)
                            //     .data()
                            //     .reduce(function(a, b) {
                            //         return intVal(a) + intVal(b);
                            //     }, 0);


                            // Update footer by showing the total with the reference of the column index 

                            $(api.column(7).footer()).html('Total');
                            $(api.column(8).footer()).html(thuTotal);
                        },
                        processing: true,
                        serverSide: true,
                        dom: "<'row'<'col-sm-4'l><'col-sm-4'f><'col-sm-4'B>>" +
                            "<'row'<'col-sm-12'tr>>" +
                            "<'row'<'col-sm-5'i><'col-sm-7'p>>",

                        //    ajax: "{{ route('admin.get-consulation-report') }}",
                        ajax: {
                            url: "{{ route('admin.get-consulation-report') }}",
                            data: function(d) {
                                d.from = $('input[name="from"]').val();
                                d.to = $('input[name="to"]').val();
                                d.therapist = $('select[name="therapist"]').val();
                                d.package = $('select[name="package"]').val();
                                d.status = $('select[name="status"]').val();

                            }
                        },
                        columns: [{
                                data: 'id',
                                name: 'id'
                            }, {
                                data: 'invoice_date',
                                name: 'invoice_date'
                            },
                            {
                                data: 'patient',
                                name: 'patient'
                            },
                            {
                                data: 'patient_name',
                                name: 'patient_name'
                            },
                            {
                                data: 'therapist',
                                name: 'therapist'
                            },
                            {
                                data: 'date',
                                name: 'date'
                            },
                            {
                                data: 'status',
                                name: 'status'
                            },
                            {
                                data: 'communication_type',
                                name: 'communication_type'
                            },
                            {
                                data: 'fee',
                                name: 'fee'
                            },

                        ],
                        "select": {
                            'style': 'multi',
                            'selector': 'td:first-child' //only checkbox can select row
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'csvHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    });
                    $(".filter").click(function() {

                        table.draw();
                    });
                });

                google.charts.load('current', {
                    'packages': ['bar']
                });
                google.charts.setOnLoadCallback(drawChart);

                function drawChart() {
                    var data = google.visualization.arrayToDataTable(<?php echo
                                                                        Js::from($result)
                                                                        ?>);

                    var options = {
                        chart: {
                            title: 'Consultation Report',
                            subtitle: 'Appoinments',
                        },
                    };

                    var chart = new google.charts.Bar(document.getElementById('barchart_material'));
                    chart.draw(data, google.charts.Bar.convertOptions(options));
                }

                $('body').on('click', '.applyBtn', function(e) {
                    e.preventDefault();
                    var url = "{{route('admin.filter-consultation-report')}}";
                    var from = $('#reportrange').data('daterangepicker').startDate.format('YYYY-MM-DD');
                    var to = $('#reportrange').data('daterangepicker').endDate.format('YYYY-MM-DD');

                    //    $("#js-loader").fadeIn();
                    $.ajax({
                        type: 'GET',
                        url: url,
                        data: {
                            from_date: from,
                            to_date: to
                        },

                        success: function(result) {
                            var data = google.visualization.arrayToDataTable(result);

                            var options = {
                                chart: {
                                    title: 'Consultation Report',
                                    subtitle: 'Appoinments',
                                },
                            };

                            var chart = new google.charts.Bar(document.getElementById('barchart_material'));
                            chart.draw(data, google.charts.Bar.convertOptions(options));
                        },
                        error: function(err) {
                            // Your Error Message
                            toastr.error(err.data);
                        }
                    });
                });


                $(window).on("load", function() {

                    var url = "{{route('admin.filter-consultation-report')}}";
                    var from = $('#reportrange').data('daterangepicker').startDate.format('YYYY-MM-DD');
                    var to = $('#reportrange').data('daterangepicker').endDate.format('YYYY-MM-DD');

                    //    $("#js-loader").fadeIn();
                    $.ajax({
                        type: 'GET',
                        url: url,
                        data: {
                            from_date: from,
                            to_date: to
                        },
                        success: function(result) {
                            var data = google.visualization.arrayToDataTable(result);

                            var options = {
                                chart: {
                                    title: 'Consultation Report',
                                    subtitle: 'Appoinments',
                                },
                            };

                            var chart = new google.charts.Bar(document.getElementById('barchart_material'));
                            chart.draw(data, google.charts.Bar.convertOptions(options));
                        },
                        error: function(err) {
                            // Your Error Message
                            toastr.error(err.data);
                        }
                    });
                });
            </script>
            @endsection