@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item active">Podcast Category</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card card-table show-entire">
                    <div class="card-body">

                        <div class="page-table-header mb-2">
                            <div class="row align-items-center">
                                <div class="col">
                                    <div class="doctor-table-blk">
                                        <h3>Podcast Category</h3>
                                        <div class="doctor-search-blk">
                                            <div class="top-nav-search table-search-blk">
                                                <form>
                                                    <input type="text" class="form-control" placeholder="Search here">
                                                    <a class="btn"><img src="{{asset('assets/img/icons/search-normal.svg')}}" alt></a>
                                                </form>
                                            </div>
                                            <div class="add-group">
                                                <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#add_podcast_category" class="btn btn-primary add-pluss ms-2"><img src="{{asset('assets/img/icons/plus.svg')}}" alt></a>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table border-0 custom-table comman-table mb-0" id="service_table">
                                <thead>
                                    <tr>
                                        <th>
                                            #
                                        </th>
                                        <th>CATEGORY NAME</th>
                                        <th>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="add_podcast_category" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered ">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add Podcast Category</h5>

                </div>
                <div class="modal-body text-center">
                    <form id="add_category" action="{{ route('admin.save-podcast-category') }}">
                        @csrf
                        <div class="row m-t-20">
                            <div class=" col-12 col-md-12 col-xl-12">
                                <div class="form-group local-forms">
                                    <label>Podcast Category <span class="login-danger">*</span></label>
                                    <input class="form-control" required name="title" type="text">
                                </div>
                            </div>
                        </div>
                        <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                            <button type="submit" class="btn btn-success ">ADD</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div id="edit_podcast_category" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered ">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Podcast Category</h5>

                </div>
                <div class="modal-body text-center">
                    <form id="edit_category" action="{{ route('admin.update-podcast-category') }}">
                        @csrf
                        <div class="row m-t-20">
                            <div class=" col-12 col-md-12 col-xl-12">
                                <div class="form-group local-forms">
                                    <label>Podcast Category <span class="login-danger">*</span></label>
                                    <input class="form-control" required name="title" id="edit_title" type="text">
                                    <input class="form-control" required name="id" id="edit_id" type="hidden">
                                </div>
                            </div>
                        </div>
                        <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                            <button type="submit" class="btn btn-success ">ADD</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div id="delete_podcast" class="modal fade delete-modal" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body text-center">
                    <img src="{{asset('assets/img/sent.png')}}" alt width="50" height="46">
                    <h3>Are you sure want to delete this ?</h3>
                    <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                        <button type="submit" class="btn btn-danger" id="delete_item">Delete</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        $(function() {
            $('#service_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admin.get-podcast-category') }}",
                columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                }, {
                    data: 'title',
                    name: 'title'
                }, {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }, ],
                "select": {
                    'style': 'multi',
                    'selector': 'td:first-child' //only checkbox can select row 
                },
            });
        });
        var deleteID;
        $('body').on('click', '#getDeleteId', function() {
            deleteID = $(this).data('id');
        })
        $(document).on('click', '#delete_item', function(e) {
            var id = deleteID;
            e.preventDefault();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token" ]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('admin.delete-podcast-category') }}",
                method: "GET",
                data: {
                    'id': id
                },
                success: function(result) {
                    $('#delete_podcast').modal('hide');
                    $('.table').DataTable().ajax.reload();
                    if (result == 1) {
                        toastr.success("Podcast Category Deleted Successfully.");
                    } else {
                        toastr.error("Something went wrong.");
                    }
                    $('.table').DataTable().ajax.reload();
                }
            });
        });

        $('#add_category').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $('.table').DataTable().ajax.reload();
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Category Added Successfully');
                    } else {
                        toastr.error(data);
                    }
                },
                error: function(err) { // Your Error Message
                    toastr.error(err);
                }
            });
        });

        $('body').on('click', '#getEditId', function() {
            id = $(this).data('id');
            name = $(this).data('value');
            $('#edit_id').val(id);
            $('#edit_title').val(name);
        })

        $('#edit_category').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $('.table').DataTable().ajax.reload();
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Category Updated Successfully');
                    } else {
                        toastr.error(data);
                    }
                },
                error: function(err) { // Your Error Message
                    toastr.error(err);
                }
            });
        });
    </script>
    @endsection