@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.packages')}}">Packages</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Edit Package</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <!-- <form method="post" action="{{ route('admin.update-package') }}"> -->
                        <form id="add_package" action="{{ route('admin.update-package') }}">
                            @csrf

                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Edit Package</h4>
                                    </div>
                                </div>

                                <div class="col-12 col-md-12 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Package Name <span class="login-danger">*</span></label>
                                        <input class="form-control" value="{{$data->title}}" required name="title" type="text">
                                        <input type="hidden" name="id" value="{{$data->id}}">
                                    </div>
                                </div>
                                <div class="col-12 col-md-12 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Service <span class="login-danger">*</span></label>
                                        <select class="form-control" name="service">
                                            @foreach(App\Models\Service::where('status','ACTIVE')->get() as $item)
                                            <option value="{{$item->id}}" {{ $item->id == $data->service_id ? 'selected' : '' }}>{{$item->service_name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div id="service_fee" style="margin-bottom: 40px;">

                                </div>

                                <div class="col-12 col-md-12 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Number of Sessions <span class="login-danger">*</span></label>
                                        <input class="form-control" value="{{$data->no_of_sessions}}" required name="no_of_sessions" type="text">
                                    </div>
                                </div>
                                <div class="col-12 col-md-12 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Duration <span class="login-danger">*</span></label>
                                        <input class="form-control" value="{{$data->duration}}" required name="duration" type="text">
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Discount <span class="login-danger">*</span></label>
                                        <input class="form-control" value="{{$data->discount}}" required name="discount" type="text" placeholder="">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-4">
                                    <div class="form-group local-top-form">
                                        <label class="local-top">Image <span class="login-danger">*</span></label>
                                        <!-- <div class="settings-btn upload-files-avator"> -->
                                        <input type="file" accept="image/*" name="image" id="file" onchange="readURL(this);" class="form-control">
                                        <!-- <label for="file" class="upload">Choose File</label>
                                        </div> -->
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-2">
                                    <div class="form-group local-top-form">
                                        <img width="80" height="80" src="{{asset('assets/uploads/package/' . $data->image)}}" class="preview" alt="">
                                    </div>
                                </div>

                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Notes <span class="login-danger">*</span></label>
                                        <textarea class="form-control" name="note" rows="3" cols="30">{{$data->description}}</textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                                <button type="submit" class="btn btn-success ">Add Package</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            var catId = <?php echo $data->service_id; ?>;
            var package_id = <?php echo $data->id; ?>;
            if (catId) {
                $.ajax({
                    url: "{{ route('admin.load-service-fee-html') }}",
                    data: {
                        'id': catId,
                        'package_id': package_id
                    },
                    type: "GET",
                    success: function(data) {
                        $('#service_fee').html(data);
                    }
                })
            }
        });
        $('#add_package').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Package Added Successfully');
                    } else {
                        toastr.error(data);
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });

        $('select[name="service"]').on('change', function() {
            var catId = $(this).val();
            var package_id = <?php echo $data->id; ?>;
            if (catId) {
                $.ajax({
                    url: "{{ route('admin.load-service-fee-html') }}",
                    data: {
                        'id': catId,
                        'package_id': package_id
                    },
                    type: "GET",
                    success: function(data) {
                        $('#service_fee').html(data);
                    }
                })
            }
        });
    </script>
    @endsection