@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.offers')}}">offers</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Add Offer</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <form id="add_offer" action="{{ route('admin.save-offer') }}">
                            @csrf

                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Add Offer</h4>
                                    </div>
                                </div>



                                <div class="col-12 col-md-12 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Offer Name <span class="login-danger">*</span></label>
                                        <input class="form-control" required name="title" type="text">
                                    </div>
                                </div>

                                <div class="col-12 col-md-12 col-xl-3">
                                    <div class="form-group local-forms">
                                        <label>promo_code <span class="login-danger">*</span></label>
                                        <input class="form-control" required name="promo_code" type="text" value="YC{{rand(1000, 9999)}}">
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group local-forms cal-icon">
                                        <label>Expiry Date <span class="login-danger">*</span></label>
                                        <input class="form-control datetimepicker" required name="expiry_date" type="text">
                                    </div>
                                </div>
                                <div class="col-12 col-md-12 col-xl-2">
                                    <div class="form-group local-forms">
                                        <label>Discount Type <span class="login-danger">*</span></label>
                                        <select class="form-control" required name="discount_type">
                                            <option value="%">%</option>
                                            <option value="₹">₹</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-12 col-md-12 col-xl-4">
                                    <div class="form-group local-forms">
                                        <label>Discount Rate <span class="login-danger">*</span></label>
                                        <input class="form-control" required name="discount_rate" type="text" placeholder="">
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-4">
                                    <div class="form-group local-top-form">
                                        <label class="local-top">Image <span class="login-danger">*</span></label>
                                        <!-- <div class="settings-btn upload-files-avator"> -->
                                        <input type="file" accept="image/*" required name="image" onchange="readURL(this);" d="file" class="form-control">
                                        <!-- <label for="file" class="upload">Choose File</label>
                                        </div> -->
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-2">
                                    <div class="form-group local-top-form">
                                        <img width="80" height="80" src="{{asset('assets/img/no-image-available.jpg')}}" class="preview" alt="">
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Notes <span class="login-danger">*</span></label>
                                        <textarea class="form-control" name="note" rows="3" cols="30"></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                                <button type="submit" class="btn btn-success ">Add offer</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $('#add_offer').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Offer Added Successfully');
                    } else {
                        toastr.error(data);
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });
    </script>
    @endsection