@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item active">Video Banners</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card card-table show-entire">
                    <div class="card-body">

                        <div class="page-table-header mb-2">
                            <div class="row align-items-center">
                                <div class="col">
                                    <div class="doctor-table-blk">
                                        <h3>Video Banners</h3>
                                        <div class="doctor-search-blk">
                                            <div class="add-group">
                                                <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#add_blog_category" class="btn btn-primary add-pluss ms-2"><img src="{{asset('assets/img/icons/plus.svg')}}" alt></a>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table border-0 custom-table comman-table mb-0 text-center" id="banners_table">
                                <thead>
                                    <tr>
                                        <th>
                                            SL.NO
                                        </th>
                                        <th>Image</th>
                                        <th>Link</th>
                                        <th>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="add_blog_category" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered ">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add Video Banners</h5>

                </div>
                <div class="modal-body text-center">
                    <form id="banners_form" action="{{ route('admin.save-video-banners') }}">
                        @csrf
                        <div class="row m-t-20">
                            <div class=" col-12 col-md-12 col-xl-12 mb-5">
                                <input type="text" class="form-control" name="link">
                            </div>
                            <div class=" col-12 col-md-12 col-xl-12 mb-5">
                                <div class="panel">
                                    <div class="button_outer">
                                        <div class="btn_upload">
                                            <input type="file" class="upload_file" name="image">
                                            Upload Image
                                        </div>
                                        <div class="processing_bar"></div>
                                        <div class="success_box"></div>
                                    </div>
                                </div>
                                <div class="error_msg"></div>
                                <div class="uploaded_file_view uploaded_view">
                                    <span class="file_remove">X</span>
                                </div>
                            </div>
                        </div>
                        <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                            <button type="submit" class="btn btn-success ">ADD</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div id="delete_banners" class="modal fade delete-modal" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body text-center">
                    <img src="{{asset('assets/img/sent.png')}}" alt width="50" height="46">
                    <h3>Are you sure want to delete this ?</h3>
                    <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                        <button type="submit" class="btn btn-danger" id="delete_item">Delete</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        $(function() {
            $('#banners_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admin.get-video-banners') }}",
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    }, {
                        data: 'image',
                        name: 'image'
                    },
                    {
                        data: 'link',
                        name: 'link'
                    }, {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
                "select": {
                    'style': 'multi',
                    'selector': 'td:first-child' //only checkbox can select row 
                },
            });
        });
        var deleteID;
        $('body').on('click', '#getDeleteId', function() {
            deleteID = $(this).data('id');
        })
        $(document).on('click', '#delete_item', function(e) {
            var id = deleteID;
            e.preventDefault();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token" ]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('admin.delete-video-banners') }}",
                method: "GET",
                data: {
                    'id': id
                },
                success: function(result) {
                    $('#delete_banners').modal('hide');
                    $('.table').DataTable().ajax.reload();
                    if (result == 1) {
                        toastr.success("Data Deleted Successfully.");
                    } else {
                        toastr.error("Something went wrong.");
                    }
                    $('.table').DataTable().ajax.reload();
                }
            });
        });

        $('#banners_form').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $('.table').DataTable().ajax.reload();
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Data Added Successfully');
                    } else {
                        toastr.error(data);
                    }
                },
                error: function(err) { // Your Error Message
                    toastr.error(err);
                }
            });
        });
    </script>
    @endsection