@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.coupons')}}">coupons</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Edit Coupons</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <form id="edit_coupons" action="{{ route('admin.update-coupons') }}">
                            @csrf

                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Edit Coupons</h4>
                                    </div>
                                </div>



                                <div class="col-12 col-md-12 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Coupons Name <span class="login-danger">*</span></label>
                                        <input type="hidden" name="id" value="{{$data->id}}">
                                        <input class="form-control" required name="title" type="text" value="{{$data->title}}">
                                    </div>
                                </div>

                                <div class="col-12 col-md-12 col-xl-3">
                                    <div class="form-group local-forms">
                                        <label>promo_code <span class="login-danger">*</span></label>
                                        <input class="form-control" required name="promo_code" type="text" value="{{$data->promo_code}}">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group local-forms cal-icon">
                                        <label>Start Date <span class="login-danger">*</span></label>
                                        <input class="form-control datetimepicker" required name="start_date" type="text" value="{{date('d/m/y', strtotime($data->start_date)) }}">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group local-forms cal-icon">
                                        <label>Expiry Date <span class="login-danger">*</span></label>
                                        <input class="form-control datetimepicker" required name="expiry_date" type="text" value="{{date('d/m/y', strtotime($data->expiry_date)) }}">
                                    </div>
                                </div>
                                <div class="col-12 col-md-12 col-xl-2">
                                    <div class="form-group local-forms">
                                        <label>Discount Type <span class="login-danger">*</span></label>
                                        <select class="form-control" required name="discount_type">
                                            <option value="%" {{ $data->discount_type == '%' ? 'selected' : '' }}>%</option>
                                            <option value="₹" {{ $data->discount_type == '₹' ? 'selected' : '' }}>₹</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-12 col-md-12 col-xl-4">
                                    <div class="form-group local-forms">
                                        <label>Discount Rate <span class="login-danger">*</span></label>
                                        <input class="form-control" required name="discount_rate" type="text" placeholder="" value="{{$data->discount_rate}}">
                                    </div>
                                </div>

                            </div>
                            <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                                <button type="submit" class="btn btn-success ">UPDATE OFFER</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $('#edit_coupons').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Coupons Details Updated Successfully');
                        location.reload();
                    } else {
                        toastr.error(data);
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });
    </script>
    @endsection