@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.blogs')}}">Blogs</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Edit Blog</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <!-- <form method="post" action="{{ route('admin.update-blog') }}"> -->
                        <form id="edit_blog" action="{{ route('admin.update-blog') }}">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Blog Details</h4>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Blog Title <span class="login-danger">*</span></label>
                                        <input class="form-control" name="title" value="{{$data->title}}" type="text" placeholder>
                                        <input type="hidden" name="id" value="{{$data->id}}">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group select-gender">
                                        <label class="gen-label">Select Author<span class="login-danger">*</span></label>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="author" checked value="F" class="form-check-input fenny_radio" {{ $data->author == 'F' ? 'checked' : ''}}>Fenny
                                            </label>
                                        </div>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="author" value="T" class="form-check-input therapist_radio" {{ $data->author == 'T' ? 'checked' : ''}}>Therapist
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group local-forms">
                                        <label>Select Therapist</label>
                                        <select class="form-control therapist" name="therapist" disabled>
                                            <option value="">--Select Therapist--</option>
                                            @foreach(App\Models\Therapist::get() as $item)
                                            <option value="{{$item->id}}" {{ $item->id == $data->therapist_id ? 'selected' : '' }}>{{$item->full_name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Blog Category <span class="login-danger">*</span></label>
                                        <select class="form-control select" name="blog_category">
                                            <option>Choose Blog Category</option>
                                            @foreach(App\Models\Blog_category::get() as $item)
                                            <option value="{{$item->id}}" {{ $item->id == $data->blog_category_id ? 'selected' : '' }}>{{$item->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Tags <small>(separated with a comma)</small> <span class="login-danger">*</span></label>
                                        <input type="text" name="tags" value="{{$data->tags}}" data-role="tagsinput" class="form-control">
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-12">
                                    <div class="form-group summer-mail">
                                        <textarea rows="4" cols="5" name="description" class="form-control summernote" placeholder="Enter your message here">{{$data->description}}</textarea>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-top-form">
                                        <label class="local-top">Blog Image<span class="login-danger">*</span></label>
                                        <!-- <div class="settings-btn upload-files-avator"> -->
                                        <input type="file" accept="image/*" name="image" id="file" onchange="readURL(this);" class="form-control">
                                        <!-- <label for="file" class="upload">Choose File</label>
                                        </div> -->
                                    </div>
                                </div>


                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Blog Color <span class="login-danger">*</span></label>
                                        <input class="form-control" name="color" value="{{$data->color}}" type="color" placeholder>
                                    </div>
                                </div>
                                <div class="offset-3 col-6">
                                    <div class="form-group local-top-form">
                                        <img width="150" height="200" src="{{asset('assets/uploads/blog/' . $data->image)}}" class="form-control preview" alt="">
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">Update Blog</button>
                                        <button type="submit" class="btn btn-primary cancel-form">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $('#edit_blog').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Blog Updated Successfully');
                    } else {
                        toastr.error(data);
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });
        $(document).ready(function() {
            $('.tags').tagsinput({
                maxTags: 2,
            });
        });
        $('body').on('click', '.therapist_radio', function() {
            $('.therapist').prop("disabled", false);
        });
        $('body').on('click', '.fenny_radio', function() {
            $('.therapist').prop("disabled", true);
        });
    </script>
    @endsection