@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item active">User </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card card-table show-entire">
                    <div class="card-body">

                        <div class="page-table-header mb-2">
                            <div class="row align-items-center">
                                <div class="col">
                                    <div class="doctor-table-blk">
                                        <h3>User </h3>
                                        <div class="col-auto text-end float-end ms-auto download-grp">

                                            <!-- <div class="add-group"> -->
                                            <a href="{{ route('admin.add-admin-user') }}" class="btn btn-primary add-pluss ms-2"><i class="far fa-plus"></i></a>
                                            <!-- </div>
                                            <div class="add-group"> -->
                                            <!-- <a href="javascript:void(0);" id="deleteMultiple" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_user"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>
                                                <button typr="submit" class="btn btn-danger" id="deleteMultiple" data-bs-dismiss="modal">Yes,
                                                    Delete It</button> -->
                                            <button class="btn btn-danger" title="Delete selected rows" data-bs-toggle="modal" href="#deleteAll"><i class="far fa-trash-alt"></i></button>

                                            <!-- </div> -->
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table border-0 custom-table comman-table mb-0" id="user_table">
                                <thead>
                                    <tr>

                                        <th>
                                            #
                                        </th>
                                        <!-- <th>Patient Identification Number
                                        </th> -->
                                        <th>NAME</th>
                                        <th>PHONE</th>
                                        <th>EMAIL</th>
                                        <th>ROLE</th>
                                        <th>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div id="delete_user" class="modal fade delete-modal" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body text-center">
                    <img src="{{asset('assets/img/sent.png')}}" alt width="50" height="46">
                    <h3>Are you sure want to delete this ?</h3>
                    <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                        <button type="submit" class="btn btn-danger" id="delete_item">Delete</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="deleteAll" class="modal fade delete-modal" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body text-center">
                    <img src="{{asset('assets/img/sent.png')}}" alt width="50" height="46">
                    <h3>Are you sure want to delete this ?</h3>
                    <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                        <button type="submit" class="btn btn-danger" id="deleteMultiple">Delete</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        $(function() {
            $('#user_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admin.get-panel-user') }}",
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    // {
                    //     data: 'p_number',
                    //     name: 'p_number'
                    // },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'phone',
                        name: 'phone'
                    },
                    {
                        data: 'email',
                        name: 'email'
                    },
                    {
                        data: 'role',
                        name: 'role'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
                "select": {
                    'style': 'multi',
                    'selector': 'td:first-child' //only checkbox can select row 
                },
            });
        });
        var deleteID;
        $('body').on('click', '#getDeleteId', function() {
            deleteID = $(this).data('id');
        })
        $(document).on('click', '#delete_item', function(e) {
            var id = deleteID;
            e.preventDefault();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token" ]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('admin.delete-user-role') }}",
                method: "GET",
                data: {
                    'id': id
                },
                success: function(result) {
                    $('#delete_user').modal('hide');
                    $('.table').DataTable().ajax.reload();
                    if (result == 1) {
                        toastr.success("User Deleted Successfully.");
                    } else if (result == 0) {
                        toastr.error("Something went wrong.");
                    } else {
                        toastr.error(result);
                    }
                    $('.table').DataTable().ajax.reload();
                }
            });
        });
    </script>
    @endsection