 @extends('admin.layout.dashboard-template')
 @section('content')
 <div class="page-wrapper">
     <div class="content">

         <div class="page-header">
             <div class="row">
                 <div class="col-sm-12">
                     <ul class="breadcrumb">
                         <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                         <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                         <li class="breadcrumb-item"><a href="{{route('admin.panel-users')}}">Users</a></li>
                         <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                         <li class="breadcrumb-item active">Edit User</li>
                     </ul>
                 </div>
             </div>
         </div>

         <div class="row">
             <div class="col-sm-12">
                 <div class="card">
                     <div class="card-body">
                         <!-- <form method="post" action="{{ route('admin.update-user') }}" enctype="multipart/form-data"> -->
                         <form id="add_user" action="{{ route('admin.update-user-role') }}" enctype="multipart/form-data">
                             @csrf
                             <div class="row">
                                 <div class="col-12">
                                     <div class="form-heading">
                                         <h4>User Details</h4>
                                     </div>
                                 </div>
                                 <div class="col-12 col-md-6 col-xl-6">
                                     <div class="form-group local-forms">
                                         <label>Name <span class="login-danger">*</span></label>
                                         <input type="hidden" name="id" value="{{$data->id}}">
                                         <input class="form-control" name="name" value="{{$data->name}}" type="text" placeholder>
                                     </div>
                                 </div>

                                 <div class="col-12 col-md-6 col-xl-6">
                                     <div class="form-group local-forms">
                                         <label>Select Role <span class="login-danger">*</span></label>
                                         <select class="form-control" name="role" required>
                                             @foreach( DB::table("roles")->orderBy('name', 'ASC')->get() as $item)
                                             <option value="{{$item->id}}" select="{{ $data->role_id == $item->id ? 'selected' : ''}}">{{$item->name}}</option>
                                             @endforeach
                                         </select>
                                     </div>
                                 </div>
                                 <div class="col-12 col-md-6 col-xl-6">
                                     <div class="form-group local-forms">
                                         <label>Email <span class="login-danger">*</span></label>
                                         <input class="form-control" name="email" type="email" value="{{$data->email}}" placeholder>
                                     </div>
                                 </div>
                                 <div class="col-12 col-md-6 col-xl-6">
                                     <div class="form-group local-forms">
                                         <label>Alternative Email <span class="login-danger">*</span></label>
                                         <input class="form-control" name="alternative_email" type="email" value="{{$data->backup_email}}" placeholder>
                                     </div>
                                 </div>
                                 <div class="col-12 col-md-6 col-xl-6">
                                     <div class="form-group local-forms ">
                                         <label>Phone <span class="login-danger">*</span></label>
                                         <input class="form-control" name="phone" value="{{$data->phone_number}}" type="text" max="10">

                                     </div>
                                 </div>


                                 <div class="col-12 col-md-6 col-xl-6">
                                     <div class="form-group select-gender">
                                         <label class="gen-label">Gender<span class="login-danger">*</span></label>
                                         <div class="form-check-inline">
                                             <label class="form-check-label">
                                                 <input type="radio" name="gender" checked="{{ $data->gender == 'MALE' ? 'checked' : ''}}" value="MALE" class="form-check-input">Male
                                             </label>
                                         </div>
                                         <div class="form-check-inline">
                                             <label class="form-check-label">
                                                 <input type="radio" name="gender" value="FEMALE" checked="{{ $data->gender == 'FEMALE' ? 'checked' : ''}}" class="form-check-input">Female
                                             </label>
                                         </div>
                                     </div>
                                 </div>



                                 <div class="col-12 col-md-6 col-xl-6">
                                     <div class="form-group local-forms cal-icon">
                                         <label>Date Of Birth <span class="login-danger"></span></label>
                                         <input class="form-control datetimepicker" name="dob" value="{{date('d/m/Y',strtotime($data->dob))}}" type="text" placeholder>
                                     </div>
                                 </div>
                                 @php
                                 if ($data->image != NULL) {
                                 $img = asset('assets/uploads/panelUser/' . $data->image);
                                 } else {
                                 $img = asset('assets/img/no-image-available.jpg');
                                 }
                                 @endphp
                                 <div class="col-12 col-md-6 col-xl-4">
                                     <div class="form-group local-top-form">
                                         <label class="local-top">Image <span class="login-danger">*</span></label>
                                         <input type="file" accept="image/*" name="image" id="file" class="form-control" onchange="readURL(this);">
                                     </div>
                                 </div>
                                 <div class="col-12 col-md-6 col-xl-2">
                                     <div class="form-group local-top-form">
                                         <img width="60" height="60" src="{{$img}}" class="img-fluid call-imgs preview" alt="">
                                     </div>
                                 </div>
                                 <div class="col-12">
                                     <div class="doctor-submit text-end">
                                         <button type="submit" class="btn btn-primary submit-form me-2">UPDATE</button>
                                         <button type="submit" class="btn btn-primary cancel-form">Cancel</button>
                                     </div>
                                 </div>
                             </div>
                         </form>
                     </div>
                 </div>
             </div>
         </div>
     </div>
     <script>
         $('#add_user').submit(function(e) {
             e.preventDefault();
             var url = $(this).attr("action");
             let formData = new FormData(this);
             $("#js-loader").fadeIn();
             $.ajax({
                 type: 'POST',
                 url: url,
                 data: formData,
                 contentType: false,
                 processData: false,
                 success: function(result) {
                     $("#js-loader").fadeOut();
                     if (result.status == true) {
                         toastr.success(result.data);
                     } else if (result.status == false) {
                         toastr.error(result.data);
                     }
                 },
                 error: function(err) {
                     // Your Error Message
                     toastr.error(err.data);
                 }
             });
         });
     </script>
     @endsection